/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.handlers;

import com.google.common.collect.Lists;
import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.api.item.IModularArmor;
import com.mjr.extraplanets.api.item.IPressureSuit;
import com.mjr.extraplanets.api.item.IRadiationSuit;
import com.mjr.extraplanets.api.prefabs.entity.EntityElectricRocketBase;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.blocks.fluid.ExtraPlanets_Fluids;
import com.mjr.extraplanets.blocks.fluid.FluidBlockEP;
import com.mjr.extraplanets.client.handlers.capabilities.CapabilityProviderStatsClient;
import com.mjr.extraplanets.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.extraplanets.compatibility.MachineMusePowersuitsCompatibility;
import com.mjr.extraplanets.handlers.capabilities.CapabilityProviderStats;
import com.mjr.extraplanets.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.extraplanets.handlers.capabilities.IStatsCapability;
import com.mjr.extraplanets.items.ExtraPlanets_Items;
import com.mjr.extraplanets.items.armor.Tier0SpaceSuitArmor;
import com.mjr.extraplanets.items.armor.modules.Module;
import com.mjr.extraplanets.items.armor.modules.ModuleHelper;
import com.mjr.extraplanets.network.ExtraPlanetsPacketHandler;
import com.mjr.extraplanets.network.PacketSimpleEP;
import com.mjr.extraplanets.util.DamageSourceEP;
import com.mjr.mjrlegendslib.network.IPacket;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class MainHandlerServer {
    private static List<ExtraPlanetsPacketHandler> packetHandlers = Lists.newCopyOnWriteArrayList();

    public static void addPacketHandler(ExtraPlanetsPacketHandler handler) {
        packetHandlers.add(handler);
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        for (ExtraPlanetsPacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            for (ExtraPlanetsPacketHandler handler : packetHandlers) {
                handler.tick((World)world);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        IStatsCapability oldStats = (IStatsCapability)event.getOriginal().getCapability(CapabilityStatsHandler.EP_STATS_CAPABILITY, null);
        IStatsCapability newStats = (IStatsCapability)event.getEntityPlayer().getCapability(CapabilityStatsHandler.EP_STATS_CAPABILITY, null);
        newStats.copyFrom(oldStats, !event.isWasDeath() || event.getOriginal().field_70170_p.func_82736_K().func_82766_b("keepInventory"));
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayerMP player;
        World world;
        IBlockState blockTest;
        if (event.player instanceof EntityPlayerMP && (blockTest = (world = event.player.field_70170_p).func_180495_p((player = (EntityPlayerMP)event.player).func_180425_c())).func_177230_c() instanceof FluidBlockEP) {
            BlockPos block = world.func_175672_r(player.func_180425_c().func_177982_a(1, 1, 0));
            world.func_175656_a(block, world.func_180494_b((BlockPos)block).field_76752_A);
            ExtraPlanets.packetPipeline.sendTo((IPacket)new PacketSimpleEP(PacketSimpleEP.EnumSimplePacket.C_MOVE_PLAYER, world.field_73011_w.func_186058_p().func_186068_a(), new Object[]{block}), player);
        }
    }

    @SubscribeEvent
    public void onEntityDealth(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityLivingBase entityLiving = event.getEntityLiving();
            IStatsCapability stats = null;
            if (entityLiving != null) {
                stats = (IStatsCapability)entityLiving.getCapability(CapabilityStatsHandler.EP_STATS_CAPABILITY, null);
            }
            if (stats.getRadiationLevel() >= 85.0) {
                stats.setRadiationLevel(80.0);
            } else if (stats.getRadiationLevel() >= 65.0 && stats.getRadiationLevel() < 85.0) {
                stats.setRadiationLevel(60.0);
            } else if (stats.getRadiationLevel() >= 50.0 && stats.getRadiationLevel() < 65.0) {
                stats.setRadiationLevel(50.0);
            }
        }
    }

    @SubscribeEvent
    public void onPlayer(TickEvent.PlayerTickEvent event) {
        if (Config.JUITPER_LIGHTING_SERVER && event.player.field_70170_p.field_73011_w.func_186058_p().func_186068_a() == Config.JUPITER_ID) {
            int lightingSpawnChance;
            Random rand = new Random();
            int addX = rand.nextInt(64);
            int addZ = rand.nextInt(64);
            if (rand.nextInt(2) == 1) {
                addX = -addX;
            }
            if (rand.nextInt(2) == 1) {
                addZ = -addZ;
            }
            if (addX <= 10) {
                addX = 10;
            }
            if (addZ <= 10) {
                addZ = 10;
            }
            if ((lightingSpawnChance = rand.nextInt(100)) == 10) {
                event.player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(event.player.field_70170_p, event.player.field_70165_t + (double)addX, (double)event.player.field_70170_p.func_175672_r(new BlockPos(event.player.field_70165_t + (double)addX, 0.0, (double)((int)event.player.field_70161_v + addZ))).func_177956_o(), event.player.field_70161_v + (double)addZ, false));
            }
        }
    }

    @SubscribeEvent
    public void onThermalArmorEvent(GCPlayerHandler.ThermalArmorEvent event) {
        if (event.armorStack == null) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.REMOVE);
            return;
        }
        if (event.armorStack.func_77973_b() == AsteroidsItems.thermalPadding && event.armorStack.func_77952_i() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == ExtraPlanets_Items.TIER_3_THERMAL_PADDING && event.armorStack.func_77952_i() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == ExtraPlanets_Items.TIER_4_THERMAL_PADDING && event.armorStack.func_77952_i() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == ExtraPlanets_Items.TIER_5_THERMAL_PADDING && event.armorStack.func_77952_i() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.NOTHING);
    }

    @SubscribeEvent
    public void onCommandEvent(CommandEvent event) {
        if (event.getCommand().func_71517_b().equalsIgnoreCase("gckit")) {
            if (event.getParameters().length == 0) {
                if (event.getSender() instanceof EntityPlayerMP) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayerMP)event.getSender()), (ItemStack)new ItemStack(ExtraPlanets_Items.ENVIRO_EMERGENCY_KIT), (int)0);
                }
            } else {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)event.getSender().func_184102_h().func_184103_al().func_152612_a(event.getParameters()[0]), (ItemStack)new ItemStack(ExtraPlanets_Items.ENVIRO_EMERGENCY_KIT), (int)0);
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(CapabilityStatsHandler.EP_PLAYER_PROP, (ICapabilityProvider)new CapabilityProviderStats((EntityPlayerMP)event.getObject()));
        } else if (event.getObject() instanceof EntityPlayer && ((EntityPlayer)event.getObject()).field_70170_p.field_72995_K) {
            this.onAttachCapabilityClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAttachCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerSP) {
            event.addCapability(CapabilityStatsClientHandler.EP_PLAYER_CLIENT_PROP, (ICapabilityProvider)new CapabilityProviderStatsClient((EntityPlayerSP)event.getObject()));
        }
    }

    public boolean isInGlowstone(EntityPlayerMP player) {
        return player.field_70170_p.func_72875_a(player.func_174813_aQ().func_72321_a((double)-0.1f, (double)-0.4f, (double)-0.1f), ExtraPlanets_Fluids.GLOWSTONE_MATERIAL);
    }

    public boolean isInMagma(EntityPlayerMP player) {
        return player.field_70170_p.func_72875_a(player.func_174813_aQ().func_72321_a((double)-0.1f, (double)-0.4f, (double)-0.1f), ExtraPlanets_Fluids.MAGMA_MATERIAL);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        if (entityLiving instanceof EntityPlayerMP) {
            this.tickTempSpaceSuit(event, entityLiving);
            this.tickModules(event, entityLiving);
            if (this.isInGlowstone((EntityPlayerMP)entityLiving)) {
                entityLiving.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 500, 0));
            } else if (this.isInMagma((EntityPlayerMP)entityLiving) && !entityLiving.func_70045_F()) {
                entityLiving.func_70015_d(18);
            }
            this.onPlayerUpdate((EntityPlayerMP)entityLiving);
            if (!OxygenUtil.isAABBInBreathableAirBlock((World)entityLiving.field_70170_p, (AxisAlignedBB)entityLiving.func_174813_aQ(), (boolean)true) && !(entityLiving.field_70170_p.func_180495_p(new BlockPos(entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v)).func_177230_c() instanceof BlockFluidBase)) {
                this.runChecks(event, entityLiving);
            }
        }
    }

    private void tickTempSpaceSuit(LivingEvent.LivingUpdateEvent event, EntityLivingBase entityLiving) {
        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        ItemStack helmet = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack leggins = (ItemStack)player.field_71071_by.field_70460_b.get(1);
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        if (helmet.func_77973_b() instanceof Tier0SpaceSuitArmor) {
            Tier0SpaceSuitArmor.setTicksLeft(helmet, Tier0SpaceSuitArmor.getTicksLeft(helmet) - 1);
            if (Tier0SpaceSuitArmor.getTicksLeft(helmet) <= 0) {
                player.field_71071_by.field_70460_b.set(3, (Object)ItemStack.field_190927_a);
            }
        }
        if (chest.func_77973_b() instanceof Tier0SpaceSuitArmor) {
            Tier0SpaceSuitArmor.setTicksLeft(chest, Tier0SpaceSuitArmor.getTicksLeft(chest) - 1);
            if (Tier0SpaceSuitArmor.getTicksLeft(chest) <= 0) {
                player.field_71071_by.field_70460_b.set(2, (Object)ItemStack.field_190927_a);
            }
        }
        if (leggins.func_77973_b() instanceof Tier0SpaceSuitArmor) {
            Tier0SpaceSuitArmor.setTicksLeft(leggins, Tier0SpaceSuitArmor.getTicksLeft(leggins) - 1);
            if (Tier0SpaceSuitArmor.getTicksLeft(leggins) <= 0) {
                player.field_71071_by.field_70460_b.set(1, (Object)ItemStack.field_190927_a);
            }
        }
        if (boots.func_77973_b() instanceof Tier0SpaceSuitArmor) {
            Tier0SpaceSuitArmor.setTicksLeft(boots, Tier0SpaceSuitArmor.getTicksLeft(boots) - 1);
            if (Tier0SpaceSuitArmor.getTicksLeft(boots) <= 0) {
                player.field_71071_by.field_70460_b.set(0, (Object)ItemStack.field_190927_a);
            }
        }
        if ((player.field_70173_aa - 1) % 90 == 0) {
            for (ItemStack item : player.field_71071_by.field_70462_a) {
                if (!(item.func_77973_b() instanceof Tier0SpaceSuitArmor)) continue;
                item.func_190920_e(0);
            }
        }
    }

    private void tickModules(LivingEvent.LivingUpdateEvent event, EntityLivingBase entityLiving) {
        int passivePower;
        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
        if (player.func_175149_v()) {
            return;
        }
        ItemStack helmet = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        ItemStack chest = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack leggins = (ItemStack)player.field_71071_by.field_70460_b.get(1);
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        if (helmet.func_77973_b() instanceof IModularArmor) {
            for (Module hemletModules : ModuleHelper.getModules(helmet)) {
                if (!hemletModules.isActive()) continue;
                passivePower = ModuleHelper.getModulePassiveCost(hemletModules);
                if ((player.field_70173_aa - 1) % 20 == 0 && ModuleHelper.hasPower(helmet, passivePower)) {
                    ModuleHelper.takeArmourPower(helmet, passivePower);
                }
                if (!ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(hemletModules))) continue;
                hemletModules.tickServer(player);
            }
        }
        if (chest.func_77973_b() instanceof IModularArmor) {
            for (Module chestModules : ModuleHelper.getModules(chest)) {
                if (!chestModules.isActive()) continue;
                passivePower = ModuleHelper.getModulePassiveCost(chestModules);
                if ((player.field_70173_aa - 1) % 20 == 0 && ModuleHelper.hasPower(chest, passivePower)) {
                    ModuleHelper.takeArmourPower(chest, passivePower);
                }
                if (!ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(chestModules))) continue;
                chestModules.tickServer(player);
            }
        }
        if (leggins.func_77973_b() instanceof IModularArmor) {
            for (Module legginsModules : ModuleHelper.getModules(leggins)) {
                if (!legginsModules.isActive()) continue;
                passivePower = ModuleHelper.getModulePassiveCost(legginsModules);
                if ((player.field_70173_aa - 1) % 20 == 0 && ModuleHelper.hasPower(leggins, passivePower)) {
                    ModuleHelper.takeArmourPower(leggins, passivePower);
                }
                if (!ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(legginsModules))) continue;
                legginsModules.tickServer(player);
            }
        }
        if (boots.func_77973_b() instanceof IModularArmor) {
            for (Module bootsModules : ModuleHelper.getModules(boots)) {
                if (!bootsModules.isActive()) continue;
                passivePower = ModuleHelper.getModulePassiveCost(bootsModules);
                if ((player.field_70173_aa - 1) % 20 == 0 && ModuleHelper.hasPower(boots, passivePower)) {
                    ModuleHelper.takeArmourPower(boots, passivePower);
                }
                if (!ModuleHelper.hasPower(helmet, ModuleHelper.getModuleUseCost(bootsModules))) continue;
                bootsModules.tickServer(player);
            }
        }
    }

    private void runChecks(LivingEvent.LivingUpdateEvent event, EntityLivingBase entityLiving) {
        EntityPlayerMP player = (EntityPlayerMP)entityLiving;
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (player.func_175149_v()) {
            return;
        }
        if (entityLiving.func_184187_bx() instanceof EntityLanderBase) {
            return;
        }
        if (entityLiving.func_184187_bx() instanceof EntityElectricRocketBase) {
            return;
        }
        if (entityLiving.func_184187_bx() instanceof EntitySpaceshipBase) {
            return;
        }
        if (entityLiving.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            ArrayList list = Lists.newArrayList((Object[])Config.SPACE_SUIT_SUPPORTED_ARMOUR);
            if (((EntityPlayerMP)entityLiving).field_70170_p.field_73011_w instanceof WorldProviderRealisticSpace) {
                if (Config.PRESSURE) {
                    this.checkPressure(event, player, ((WorldProviderRealisticSpace)player.field_70170_p.field_73011_w).getPressureLevel(), list);
                }
                if (Config.RADIATION) {
                    this.checkRadiation(event, player, ((WorldProviderRealisticSpace)player.field_70170_p.field_73011_w).getSolarRadiationLevel(), list);
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderMoon) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    this.checkPressure(event, player, 80, list);
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    this.checkRadiation(event, player, Config.MOON_RADIATION_AMOUNT, list);
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderMars) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    this.checkPressure(event, player, 90, list);
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    this.checkRadiation(event, player, Config.MARS_RADIATION_AMOUNT, list);
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderVenus) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    this.checkPressure(event, player, 100, list);
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    this.checkRadiation(event, player, Config.VENUS_RADIATION_AMOUNT, list);
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    this.checkPressure(event, player, 100, list);
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    this.checkRadiation(event, player, Config.ASTEROIDS_RADIATION_AMOUNT, list);
                }
            } else if (player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation) {
                if (Config.GC_PRESSURE && Config.PRESSURE) {
                    this.checkPressure(event, player, 100, list);
                }
                if (Config.GC_RADIATION && Config.RADIATION) {
                    this.checkRadiation(event, player, Config.SPACE_STATION_RADIATION_AMOUNT, list);
                }
            } else if (Config.OTHER_ADDON_PLANET_MOON_RAD_VALUES_LIST.containsKey(((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getCelestialBody().getUnlocalizedName())) {
                this.checkRadiation(event, player, Config.OTHER_ADDON_PLANET_MOON_RAD_VALUES_LIST.get(((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getCelestialBody().getUnlocalizedName()), list);
            }
        }
    }

    public boolean isValidSpaceSuit(EntityPlayer player, ItemStack helmet, ItemStack chest, ItemStack leggins, ItemStack boots, List<String> list, boolean pressure) {
        if (CompatibilityManager.isAndroid((EntityPlayer)player)) {
            return true;
        }
        if (helmet == ItemStack.field_190927_a) {
            return false;
        }
        if (chest == ItemStack.field_190927_a) {
            return false;
        }
        if (leggins == ItemStack.field_190927_a) {
            return false;
        }
        if (boots == ItemStack.field_190927_a) {
            return false;
        }
        boolean validHelmet = false;
        boolean validChest = false;
        boolean validLeggings = false;
        boolean validBoots = false;
        if (pressure) {
            if (helmet.func_77973_b() instanceof IPressureSuit) {
                validHelmet = true;
            }
            if (chest.func_77973_b() instanceof IPressureSuit) {
                validChest = true;
            }
            if (leggins.func_77973_b() instanceof IPressureSuit) {
                validLeggings = true;
            }
            if (boots.func_77973_b() instanceof IPressureSuit) {
                validBoots = true;
            }
        } else {
            if (helmet.func_77973_b() instanceof IRadiationSuit) {
                validHelmet = true;
            }
            if (chest.func_77973_b() instanceof IRadiationSuit) {
                validChest = true;
            }
            if (leggins.func_77973_b() instanceof IRadiationSuit) {
                validLeggings = true;
            }
            if (boots.func_77973_b() instanceof IRadiationSuit) {
                validBoots = true;
            }
        }
        if (validHelmet && validChest && validLeggings && validBoots) {
            return true;
        }
        if (Loader.isModLoaded((String)"powersuits")) {
            if (pressure) {
                if (!validHelmet) {
                    validHelmet = MachineMusePowersuitsCompatibility.isPressureModuleInstalled(helmet);
                }
                if (!validChest) {
                    validChest = MachineMusePowersuitsCompatibility.isPressureModuleInstalled(chest);
                }
                if (!validLeggings) {
                    validLeggings = MachineMusePowersuitsCompatibility.isPressureModuleInstalled(leggins);
                }
                if (!validBoots) {
                    validBoots = MachineMusePowersuitsCompatibility.isPressureModuleInstalled(boots);
                }
            } else {
                if (!validHelmet) {
                    validHelmet = MachineMusePowersuitsCompatibility.isRadiationModuleInstalled(helmet);
                }
                if (!validChest) {
                    validChest = MachineMusePowersuitsCompatibility.isRadiationModuleInstalled(chest);
                }
                if (!validLeggings) {
                    validLeggings = MachineMusePowersuitsCompatibility.isRadiationModuleInstalled(leggins);
                }
                if (!validBoots) {
                    validBoots = MachineMusePowersuitsCompatibility.isRadiationModuleInstalled(boots);
                }
            }
            if (validHelmet && validChest && validLeggings && validBoots) {
                return true;
            }
        }
        for (String temp : list) {
            if (!(temp = temp.substring(0, temp.lastIndexOf(58))).equalsIgnoreCase(helmet.func_77973_b().getRegistryName().toString())) continue;
            validHelmet = true;
        }
        for (String temp : list) {
            if (!(temp = temp.substring(0, temp.lastIndexOf(58))).equalsIgnoreCase(chest.func_77973_b().getRegistryName().toString())) continue;
            validChest = true;
        }
        for (String temp : list) {
            if (!(temp = temp.substring(0, temp.lastIndexOf(58))).equalsIgnoreCase(leggins.func_77973_b().getRegistryName().toString())) continue;
            validLeggings = true;
        }
        for (String temp : list) {
            if (!(temp = temp.substring(0, temp.lastIndexOf(58))).equalsIgnoreCase(boots.func_77973_b().getRegistryName().toString())) continue;
            validBoots = true;
        }
        return validHelmet && validChest && validLeggings && validBoots;
    }

    public int getTier(ItemStack testItem, List<String> list) {
        if (testItem.func_77973_b() instanceof IRadiationSuit) {
            return ((IRadiationSuit)testItem.func_77973_b()).getArmorTier();
        }
        for (String line : list) {
            if (line.length() == 0 || !line.contains(":") || !line.substring(0, line.lastIndexOf(58)).equalsIgnoreCase(testItem.func_77973_b().getRegistryName().toString())) continue;
            return Integer.parseInt(line.substring(line.lastIndexOf(58) + 1));
        }
        if (Loader.isModLoaded((String)"powersuits")) {
            return MachineMusePowersuitsCompatibility.getHighestRadiationTierModuleInstalled(testItem);
        }
        return -1;
    }

    private void checkPressure(LivingEvent.LivingUpdateEvent event, EntityPlayerMP playerMP, int amount, List<String> list) {
        if ((playerMP.field_70173_aa - 1) % 50 == 0) {
            ItemStack boots;
            ItemStack leggins;
            ItemStack chest;
            ItemStack helmet;
            if (amount == 0) {
                return;
            }
            if ((playerMP.field_70173_aa - 1) % 300 == 0 && Config.DEBUG_MODE) {
                MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Environment Pressure Amount: " + amount));
            }
            if (!this.isValidSpaceSuit((EntityPlayer)playerMP, helmet = (ItemStack)playerMP.field_71071_by.field_70460_b.get(3), chest = (ItemStack)playerMP.field_71071_by.field_70460_b.get(2), leggins = (ItemStack)playerMP.field_71071_by.field_70460_b.get(1), boots = (ItemStack)playerMP.field_71071_by.field_70460_b.get(0), list, true)) {
                float tempLevel = amount;
                tempLevel = tempLevel / 100.0f * 8.0f;
                if ((playerMP.field_70173_aa - 1) % 100 == 0 && Config.DEBUG_MODE) {
                    MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Damage Amount for Pressure: " + tempLevel));
                }
                playerMP.func_70097_a((DamageSource)DamageSourceEP.pressure, tempLevel);
            }
        }
    }

    private void checkRadiation(LivingEvent.LivingUpdateEvent event, EntityPlayerMP playerMP, int amount, List<String> list) {
        ItemStack boots;
        ItemStack leggins;
        ItemStack chest;
        if (amount == 0) {
            return;
        }
        if ((playerMP.field_70173_aa - 1) % 300 == 0 && Config.DEBUG_MODE) {
            MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Environment Radiation Amount: " + amount));
        }
        boolean doDamage = false;
        boolean doArmorCheck = false;
        double damageToTake = 0.0;
        double damageModifer = 0.0;
        int tierValue = 0;
        ItemStack helmet = (ItemStack)playerMP.field_71071_by.field_70460_b.get(3);
        if (!this.isValidSpaceSuit((EntityPlayer)playerMP, helmet, chest = (ItemStack)playerMP.field_71071_by.field_70460_b.get(2), leggins = (ItemStack)playerMP.field_71071_by.field_70460_b.get(1), boots = (ItemStack)playerMP.field_71071_by.field_70460_b.get(0), list, false)) {
            damageModifer = 0.1;
            doDamage = true;
        } else {
            doArmorCheck = true;
            doDamage = false;
        }
        if (doArmorCheck) {
            double helmetTier = this.getTier(helmet, list);
            double chestTier = this.getTier(chest, list);
            double legginsTier = this.getTier(leggins, list);
            double bootsTier = this.getTier(boots, list);
            if (helmetTier == 0.0) {
                helmetTier = 0.25;
            }
            if (chestTier == 0.0) {
                chestTier = 0.25;
            }
            if (legginsTier == 0.0) {
                legginsTier = 0.25;
            }
            if (bootsTier == 0.0) {
                bootsTier = 0.25;
            }
            if ((playerMP.field_70173_aa - 1) % 100 == 0 && Config.DEBUG_MODE) {
                MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Helmet Tier: " + helmetTier));
                MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Chest Tier: " + chestTier));
                MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Leggins Tier: " + legginsTier));
                MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Boots Tier: " + bootsTier));
            }
            tierValue = (int)((helmetTier + chestTier + legginsTier + bootsTier) / 2.0);
            damageToTake = 0.005 * (double)tierValue;
            doDamage = true;
        }
        if (doDamage) {
            IStatsCapability stats = null;
            if (playerMP != null) {
                stats = (IStatsCapability)playerMP.getCapability(CapabilityStatsHandler.EP_STATS_CAPABILITY, null);
            }
            if (stats.getRadiationLevel() >= 100.0) {
                if ((playerMP.field_70173_aa - 1) % 50 == 0) {
                    playerMP.func_70097_a((DamageSource)DamageSourceEP.radiation, 3.0f);
                }
            } else if (stats.getRadiationLevel() >= 0.0) {
                double tempLevel = 0.0;
                if (amount < 10) {
                    damageModifer = 0.005625 - damageToTake / 2.0 / 10.0;
                    tempLevel = damageModifer * (double)amount / 100.0;
                } else {
                    damageModifer = 0.001875 - damageToTake / 2.0 / 10.0;
                    if (damageModifer < 0.0) {
                        damageModifer = 2.25E-4;
                    }
                    tempLevel = damageModifer * (double)(amount / 10) / 6.0;
                }
                if ((playerMP.field_70173_aa - 1) % 100 == 0 && Config.DEBUG_MODE) {
                    MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Gained amount of Radiation: " + tempLevel));
                }
                stats.setRadiationLevel(stats.getRadiationLevel() + tempLevel);
            } else {
                stats.setRadiationLevel(0.0);
            }
            if ((playerMP.field_70173_aa - 1) % 100 == 0 && Config.DEBUG_MODE) {
                MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Player Current Radiation Amount: " + stats.getRadiationLevel()));
            }
        }
    }

    public void onPlayerUpdate(EntityPlayerMP player) {
        int tick = player.field_70173_aa - 1;
        boolean isInGCDimension = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider;
        IStatsCapability stats = (IStatsCapability)player.getCapability(CapabilityStatsHandler.EP_STATS_CAPABILITY, null);
        if ((isInGCDimension || player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation) && Config.RADIATION) {
            if (tick % 30 == 0) {
                this.sendSolarRadiationPacket(player, stats);
                if (Config.RADIATION_OVERTIME_REDUCE_AMOUNT != 0.0) {
                    double temp = stats.getRadiationLevel();
                    double level = temp * (Config.RADIATION_OVERTIME_REDUCE_AMOUNT * 1.5) / 100.0;
                    if (level <= 0.0) {
                        stats.setRadiationLevel(0.0);
                    } else {
                        if (tick % 100 == 0 && Config.DEBUG_MODE) {
                            MessageUtilities.debugMessageToLog((String)"extraplanets", (String)("Auto Reduced Radiation Amount: " + level));
                        }
                        stats.setRadiationLevel(stats.getRadiationLevel() - level);
                    }
                }
            }
        } else if (tick % 30 == 0 && Config.RADIATION_SLEEPING_REDUCE_AMOUNT != 0) {
            double temp = stats.getRadiationLevel();
            double level = temp * Config.RADIATION_OVERTIME_REDUCE_AMOUNT / 100.0;
            if (level <= 0.0) {
                stats.setRadiationLevel(0.0);
            } else {
                stats.setRadiationLevel(stats.getRadiationLevel() - level);
            }
        }
    }

    protected void sendSolarRadiationPacket(EntityPlayerMP player, IStatsCapability stats) {
        ExtraPlanets.packetPipeline.sendTo((IPacket)new PacketSimpleEP(PacketSimpleEP.EnumSimplePacket.C_UPDATE_SOLAR_RADIATION_LEVEL, player.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), new Object[]{stats.getRadiationLevel()}), player);
    }

    @SubscribeEvent
    public void onSleepInBedEvent(PlayerWakeUpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!(player.field_70170_p.field_72995_K || event.wakeImmediately() || event.updateWorld())) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            IStatsCapability stats = null;
            if (playerMP != null) {
                stats = (IStatsCapability)playerMP.getCapability(CapabilityStatsHandler.EP_STATS_CAPABILITY, null);
            }
            if (Config.RADIATION_SLEEPING_REDUCE_AMOUNT != 0) {
                double temp = stats.getRadiationLevel();
                double level = temp * (double)Config.RADIATION_SLEEPING_REDUCE_AMOUNT / 100.0;
                if (level <= 0.0) {
                    stats.setRadiationLevel(0.0);
                } else {
                    stats.setRadiationLevel(stats.getRadiationLevel() - level);
                    PlayerUtilties.sendMessage((EntityPlayer)player, (String)("" + TextFormatting.AQUA + TextFormatting.BOLD + playerMP.func_70005_c_() + TextFormatting.GOLD + ", " + TranslateUtilities.translate((String)"gui.radiation.reduced.message") + " " + Config.RADIATION_SLEEPING_REDUCE_AMOUNT + "% " + TranslateUtilities.translate((String)"gui.radiation.reduced.message.2")));
                    PlayerUtilties.sendMessage((EntityPlayer)player, (String)("" + TextFormatting.AQUA + TextFormatting.BOLD + playerMP.func_70005_c_() + TextFormatting.DARK_AQUA + ", " + TranslateUtilities.translate((String)"gui.radiation.current.message") + ": " + (int)stats.getRadiationLevel() + "/100"));
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && (event.player.field_70170_p.field_73011_w instanceof WorldProviderRealisticSpace || event.player.field_70170_p.field_73011_w instanceof WorldProviderMoon || event.player.field_70170_p.field_73011_w instanceof WorldProviderMars || event.player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids || event.player.field_70170_p.field_73011_w instanceof WorldProviderVenus || event.player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation)) {
            EntityPlayer player = event.player;
            int amount = 0;
            if (event.player.field_70170_p.field_73011_w instanceof WorldProviderRealisticSpace) {
                amount = ((WorldProviderRealisticSpace)event.player.field_70170_p.field_73011_w).getSolarRadiationLevel();
            }
            if (event.player.field_70170_p.field_73011_w instanceof WorldProviderMoon) {
                amount = Config.MOON_RADIATION_AMOUNT;
            }
            if (event.player.field_70170_p.field_73011_w instanceof WorldProviderMars) {
                amount = Config.MARS_RADIATION_AMOUNT;
            }
            if (event.player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                amount = Config.ASTEROIDS_RADIATION_AMOUNT;
            }
            if (event.player.field_70170_p.field_73011_w instanceof WorldProviderVenus) {
                amount = Config.VENUS_RADIATION_AMOUNT;
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation) {
                amount = Config.SPACE_STATION_RADIATION_AMOUNT;
            }
            PlayerUtilties.sendMessage((EntityPlayer)player, (String)("" + TextFormatting.GOLD + TextFormatting.BOLD + player.func_70005_c_() + TextFormatting.DARK_RED + ", " + TranslateUtilities.translate((String)"gui.radiation.subject.message") + " " + amount + "/100% " + TranslateUtilities.translate((String)"gui.radiation.type.message") + ""));
            PlayerUtilties.sendMessage((EntityPlayer)player, (String)(TextFormatting.DARK_GREEN + TranslateUtilities.translate((String)"gui.radiation.reverse.message") + "!"));
            PlayerUtilties.sendMessage((EntityPlayer)player, (String)(TextFormatting.GOLD + TranslateUtilities.translate((String)"gui.radiation.cancel.message") + "!"));
            PlayerUtilties.sendMessage((EntityPlayer)player, (String)(TextFormatting.DARK_AQUA + "Radiation Calculator:"));
            player.func_145747_a(ForgeHooks.newChatWithLinks((String)"https://www.mjrlegends.com/extraplanetsradiation.php"));
        }
    }
}

