/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.items.armor.modules;

import com.mjr.extraplanets.api.item.IModularArmor;
import com.mjr.extraplanets.items.armor.bases.ElectricArmorBase;
import com.mjr.extraplanets.items.armor.modules.ExtraPlanets_Modules;
import com.mjr.extraplanets.items.armor.modules.Module;
import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ModuleHelper {
    public static void setupModulesNBT(ItemStack item) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        if (item.func_77973_b() instanceof IModularArmor) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (!item.func_77942_o()) {
                NBTTagList tagList = new NBTTagList();
                nbt.func_74782_a("modules", (NBTBase)tagList);
                item.func_77982_d(nbt);
            }
        }
    }

    public static List<Module> getModules(ItemStack item) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return new ArrayList<Module>();
        }
        ArrayList<Module> temp = new ArrayList<Module>();
        if (item.func_77942_o()) {
            NBTTagCompound nbt = item.func_77978_p();
            NBTTagList tagList = nbt.func_150295_c("modules", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                for (int j = 0; j < ExtraPlanets_Modules.modules.size(); ++j) {
                    NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
                    if (!ExtraPlanets_Modules.modules.get(j).getName().equalsIgnoreCase(nbttagcompound.func_74779_i("module"))) continue;
                    Module tempModule = ExtraPlanets_Modules.modules.get(j);
                    tempModule.setActive(nbttagcompound.func_74767_n("active"));
                    temp.add(tempModule);
                }
            }
            return temp;
        }
        return new ArrayList<Module>();
    }

    public static void setModules(ItemStack item, List<Module> temp) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        item.func_77982_d(new NBTTagCompound());
        for (Module module : temp) {
            ModuleHelper.addModule(item, module);
        }
    }

    public static void addModule(ItemStack item, Module module) {
        ModuleHelper.addModule(item, module, module.isActive());
    }

    public static void addModule(ItemStack item, Module module, boolean active) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        if (!item.func_77942_o()) {
            ModuleHelper.setupModulesNBT(item);
        }
        NBTTagCompound nbt = item.func_77978_p();
        NBTTagList tagList = nbt.func_150295_c("modules", 10);
        NBTTagCompound moduleNBT = new NBTTagCompound();
        moduleNBT.func_74778_a("module", module.getName());
        moduleNBT.func_74757_a("active", active);
        tagList.func_74742_a((NBTBase)moduleNBT);
        nbt.func_74782_a("modules", (NBTBase)tagList);
        item.func_77982_d(nbt);
    }

    public static void updateModuleActiveState(ItemStack item, Module module, boolean active) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        List<Module> temp = ModuleHelper.getModules(item);
        for (Module tempModule : temp) {
            if (!tempModule.getName().equalsIgnoreCase(module.getName())) continue;
            tempModule.setActive(active);
        }
        ModuleHelper.setModules(item, temp);
    }

    public static void removeModule(ItemStack item, Module module) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        ArrayList<Module> newModules = new ArrayList<Module>();
        for (Module tempModule : ModuleHelper.getModules(item)) {
            if (tempModule.getName().equalsIgnoreCase(module.getName())) continue;
            newModules.add(tempModule);
        }
        ModuleHelper.setModules(item, newModules);
    }

    public static boolean installModule(ItemStack item, Module module, EntityPlayer player) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return false;
        }
        if (!ModuleHelper.checkModuleCompact(item, module)) {
            return false;
        }
        boolean hadRequirements = true;
        for (ItemStack itemTemp : module.getRequirements()) {
            if (player.field_71071_by.func_70431_c(itemTemp)) continue;
            hadRequirements = false;
        }
        if (hadRequirements) {
            for (ItemStack itemTemp : module.getRequirements()) {
                boolean takenStack = false;
                if (!player.field_71071_by.func_70431_c(itemTemp)) continue;
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack testStack;
                    if (takenStack || !ItemStack.func_179545_c((ItemStack)(testStack = player.field_71071_by.func_70301_a(i)), (ItemStack)itemTemp)) continue;
                    ItemStack newStack = player.field_71071_by.func_70301_a(i);
                    if (testStack.func_190916_E() > itemTemp.func_190916_E()) {
                        newStack.func_190920_e(newStack.func_190916_E() - itemTemp.func_190916_E());
                        takenStack = true;
                        player.field_71071_by.func_70299_a(i, newStack);
                        continue;
                    }
                    if (testStack.func_190916_E() != itemTemp.func_190916_E()) continue;
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    takenStack = true;
                }
            }
            ModuleHelper.addModule(item, module);
            return true;
        }
        return false;
    }

    public static void uninstallModule(ItemStack item, Module module, EntityPlayer player) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        int slot = player.field_71071_by.func_70447_i();
        if (slot == -1) {
            PlayerUtilties.sendMessage((EntityPlayer)player, (String)TranslateUtilities.translate((String)"gui.module.inventory_full.name"));
            return;
        }
        ModuleHelper.removeModule(item, module);
        for (int i = 0; i < module.getRequirements().size(); ++i) {
            ItemStack itemStack = module.getRequirements().get(i).func_77946_l();
            if (slot == -1) {
                player.func_70099_a(itemStack, 0.0f);
                return;
            }
            player.field_71071_by.func_70299_a(slot, itemStack);
        }
    }

    public static boolean checkModuleCompact(ItemStack item, Module module) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return false;
        }
        try {
            EntityEquipmentSlot slotTemp = EntityLiving.func_184640_d((ItemStack)item);
            int slot = slotTemp.func_188454_b();
            return slot == module.getSlotType();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean hasModule(ItemStack item, Module module) {
        return ModuleHelper.hasModule(item, module.getName());
    }

    public static boolean hasModule(ItemStack item, String moduleName) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return false;
        }
        List<Module> temp = ModuleHelper.getModules(item);
        for (Module tempModule : temp) {
            if (!moduleName.equalsIgnoreCase(tempModule.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isModuleActive(ItemStack item, Module module) {
        return ModuleHelper.isModuleActive(item, module.getName());
    }

    public static boolean isModuleActive(ItemStack item, String moduleName) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return false;
        }
        List<Module> temp = ModuleHelper.getModules(item);
        for (Module tempModule : temp) {
            if (!moduleName.equalsIgnoreCase(tempModule.getName())) continue;
            return tempModule.isActive();
        }
        return false;
    }

    public static int getModulePassiveCost(Module module) {
        return ModuleHelper.getModulePassiveCost(module.getName());
    }

    public static int getModulePassiveCost(String moduleName) {
        List<Module> temp = ExtraPlanets_Modules.modules;
        for (Module tempModule : temp) {
            if (!moduleName.equalsIgnoreCase(tempModule.getName())) continue;
            return tempModule.getPassivePowerCost();
        }
        return 0;
    }

    public static int getModuleUseCost(Module module) {
        return ModuleHelper.getModuleUseCost(module.getName());
    }

    public static int getModuleUseCost(String moduleName) {
        List<Module> temp = ExtraPlanets_Modules.modules;
        for (Module tempModule : temp) {
            if (!moduleName.equalsIgnoreCase(tempModule.getName())) continue;
            return tempModule.getUsePowerCost();
        }
        return 0;
    }

    public static int getArmourStoredPower(ItemStack item) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return 0;
        }
        return (int)((ElectricArmorBase)item.func_77973_b()).getElectricityStored(item);
    }

    public static void takeArmourPower(ItemStack item, int power) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return;
        }
        ((ElectricArmorBase)item.func_77973_b()).discharge(item, power, true);
    }

    public static boolean hasPower(ItemStack item, int power) {
        if (!(item.func_77973_b() instanceof IModularArmor)) {
            return false;
        }
        return ModuleHelper.getArmourStoredPower(item) >= power;
    }
}

