/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.neutral;

import logictechcorp.netherex.init.NetherExLootTables;
import logictechcorp.netherex.init.NetherExSoundEvents;
import logictechcorp.netherex.init.NetherExTextures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySalamander
extends EntityMob {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntitySalamander.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySalamander(World world) {
        super(world);
        this.field_70178_ae = true;
        this.func_70105_a(1.25f, 0.5f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.setRandomType();
        return super.func_180482_a(difficulty, data);
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (this.getType() == Type.ORANGE) {
                entity.func_70015_d(4);
            } else {
                entity.func_70015_d(8);
            }
        }
        return super.func_70652_k(entity);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        String type = this.getType() == Type.ORANGE ? "orange" : "black";
        return I18n.func_74838_a((String)("entity.netherex:" + type + "_salamander.name"));
    }

    protected ResourceLocation func_184647_J() {
        return this.getType().getLootTable();
    }

    protected SoundEvent func_184639_G() {
        return NetherExSoundEvents.SALAMANDER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.SALAMANDER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.SALAMANDER_DEATH;
    }

    public Type getType() {
        return Type.getFromOrdinal((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    private void setRandomType() {
        this.setType(this.field_70146_Z.nextInt(10) != 0 ? Type.ORANGE : Type.BLACK);
    }

    public void setType(Type type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)type.ordinal());
    }

    public static enum Type {
        ORANGE(NetherExTextures.ORANGE_SALAMANDER, NetherExLootTables.ORANGE_SALAMANDER),
        BLACK(NetherExTextures.BLACK_SALAMANDER, NetherExLootTables.BLACK_SALAMANDER);

        ResourceLocation texture;
        ResourceLocation lootTable;

        private Type(ResourceLocation texture, ResourceLocation lootTable) {
            this.texture = texture;
            this.lootTable = lootTable;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public ResourceLocation getLootTable() {
            return this.lootTable;
        }

        static Type getFromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= Type.values().length) {
                ordinal = 0;
            }
            return Type.values()[ordinal];
        }
    }
}

