/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.passive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import logictechcorp.libraryex.entity.trade.ITrader;
import logictechcorp.libraryex.trade.Trade;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.ai.EntityAIMoveInFenceGates;
import logictechcorp.netherex.entity.ai.EntityAIPigtificateFollowGoldGolem;
import logictechcorp.netherex.entity.ai.EntityAIPigtificateInteract;
import logictechcorp.netherex.entity.ai.EntityAIPigtificateLookAtTradePlayer;
import logictechcorp.netherex.entity.ai.EntityAIPigtificateMate;
import logictechcorp.netherex.entity.ai.EntityAIPigtificatePlay;
import logictechcorp.netherex.entity.ai.EntityAIPigtificateTradePlayer;
import logictechcorp.netherex.entity.ai.EntityAIRestrictFenceGateUse;
import logictechcorp.netherex.entity.ai.EntityAIUseFenceGate;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.init.NetherExCriteria;
import logictechcorp.netherex.init.NetherExItems;
import logictechcorp.netherex.init.NetherExPigtificates;
import logictechcorp.netherex.init.NetherExRegistries;
import logictechcorp.netherex.init.NetherExSoundEvents;
import logictechcorp.netherex.village.PigtificateProfession;
import logictechcorp.netherex.village.PigtificateVillage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityPigtificate
extends EntityAgeable
implements ITrader {
    private static final DataParameter<String> PROFESSION = EntityDataManager.func_187226_a(EntityPigtificate.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> CAREER = EntityDataManager.func_187226_a(EntityPigtificate.class, (DataSerializer)DataSerializers.field_187192_b);
    private int careerLevel;
    private int tickCounter;
    private int timeUntilRestock;
    private PigtificateVillage village;
    private boolean needsInitialization;
    private boolean willingToMate;
    private boolean mating;
    private boolean playing;
    private boolean additionalTasksSet;
    private boolean lookingForHome;
    private EntityPlayer customer;
    private MerchantRecipeList trades;
    private UUID lastCustomer;
    private final InventoryBasic inventory;

    public EntityPigtificate(World world) {
        super(world);
        this.inventory = new InventoryBasic("Items", false, 8);
        this.field_70178_ae = true;
        this.func_98053_h(true);
        this.func_70105_a(0.6f, 1.95f);
    }

    public EntityPigtificate(World world, PigtificateProfession profession) {
        super(world);
        this.setProfession(profession);
        this.setCareer((PigtificateProfession.Career)this.getProfession().getRandomCareer(this.field_70146_Z));
        this.inventory = new InventoryBasic("Items", false, 8);
        this.field_70178_ae = true;
        this.func_98053_h(true);
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PROFESSION, (Object)NetherExPigtificates.DIMWIT.getName().toString());
        this.field_70180_af.func_187214_a(CAREER, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPigtificateTradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPigtificateLookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveInFenceGates((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictFenceGateUse((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIUseFenceGate((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPigtificateMate(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIPigtificateFollowGoldGolem(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIPigtificateInteract(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70619_bc() {
        if (this.tickCounter-- <= 0) {
            BlockPos blockPos = new BlockPos((Entity)this);
            NetherEx.PIGTIFICATE_VILLAGE_MANAGER.getVillageData(this.field_70170_p, true).addPigtificate(blockPos);
            this.tickCounter = 70 + this.field_70146_Z.nextInt(50);
            this.village = NetherEx.PIGTIFICATE_VILLAGE_MANAGER.getVillageData(this.field_70170_p, true).getNearestVillage(blockPos, 32);
            if (this.village == null) {
                this.func_110177_bN();
            } else {
                BlockPos villagePos = this.village.getCenter();
                this.func_175449_a(villagePos, this.village.getRadius());
                if (this.lookingForHome) {
                    this.lookingForHome = false;
                    this.village.setDefaultPlayerReputation(5);
                }
            }
        }
        if (!this.isTrading() && this.timeUntilRestock > 0) {
            --this.timeUntilRestock;
            if (this.timeUntilRestock <= 0) {
                if (this.needsInitialization) {
                    for (MerchantRecipe trade : this.trades) {
                        if (!trade.func_82784_g()) continue;
                        trade.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    this.populateTradeList();
                    this.needsInitialization = false;
                    if (this.village != null && this.lastCustomer != null) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                        this.village.modifyPlayerReputation(this.lastCustomer, 1);
                    }
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    protected void func_175445_a(EntityItem item) {
        ItemStack stack = item.func_92059_d();
        if (this.canPickupItem(stack.func_77973_b())) {
            ItemStack modifiedStack = this.inventory.func_174894_a(stack);
            if (modifiedStack.func_190926_b()) {
                item.func_70106_y();
            } else {
                stack.func_190920_e(modifiedStack.func_190916_E());
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("Profession", this.getProfession().getName().toString());
        compound.func_74768_a("Career", this.getCareer().getId());
        compound.func_74768_a("CareerLevel", this.careerLevel);
        compound.func_74757_a("Willing", this.willingToMate);
        if (this.trades != null) {
            compound.func_74782_a("Trades", (NBTBase)this.trades.func_77202_a());
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("Inventory", (NBTBase)list);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setProfession((PigtificateProfession)NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValue(new ResourceLocation(compound.func_74779_i("Profession"))));
        this.setCareer((PigtificateProfession.Career)this.getProfession().getCareer(compound.func_74762_e("Career")));
        this.setCareerLevel(compound.func_74762_e("CareerLevel"));
        this.setWillingToMate(compound.func_74767_n("Willing"));
        if (compound.func_150297_b("Trades", 10)) {
            NBTTagCompound trades = compound.func_74775_l("Trades");
            this.trades = new MerchantRecipeList(trades);
        }
        NBTTagList list = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.inventory.func_174894_a(stack);
        }
        this.func_98053_h(true);
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigatePigtificate((EntityLiving)this, world);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingData) {
        this.setRandomProfessionAndCareer();
        this.setAdditionalAITasks();
        this.populateTradeList();
        return super.func_180482_a(difficulty, livingData);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityPigtificate pigtificate = new EntityPigtificate(this.field_70170_p);
        pigtificate.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)pigtificate)), null);
        return pigtificate;
    }

    public void func_70645_a(DamageSource source) {
        if (this.village != null) {
            Entity entity = source.func_76346_g();
            if (entity != null) {
                if (entity instanceof EntityPlayer) {
                    this.village.modifyPlayerReputation(entity.func_110124_au(), -2);
                } else if (entity instanceof IMob) {
                    this.village.endMatingSeason();
                }
            } else {
                EntityPlayer entityplayer = this.field_70170_p.func_72890_a((Entity)this, 16.0);
                if (entityplayer != null) {
                    this.village.endMatingSeason();
                }
            }
        }
        super.func_70645_a(source);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 12) {
            this.spawnParticles(EnumParticleTypes.HEART);
        } else if (id == 13) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_ANGRY);
        } else if (id == 14) {
            this.spawnParticles(EnumParticleTypes.VILLAGER_HAPPY);
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(EnumParticleTypes particleType) {
        for (int i = 0; i < 5; ++i) {
            double x = this.field_70146_Z.nextGaussian() * 0.02;
            double y = this.field_70146_Z.nextGaussian() * 0.02;
            double z = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 1.0 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, x, y, z, new int[0]);
        }
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            this.timeUntilRestock = 40;
            this.needsInitialization = true;
            this.willingToMate = true;
            this.lastCustomer = this.customer != null ? this.customer.func_110124_au() : null;
            i += 5;
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
        if (this.customer instanceof EntityPlayerMP) {
            NetherExCriteria.PIGTIFICATE_TRADE.trigger((EntityPlayerMP)this.customer, this, recipe.func_77397_d());
        }
    }

    public void func_110297_a_(ItemStack stack) {
    }

    private void populateTradeList() {
        List trades;
        if (this.careerLevel != 0) {
            this.setCareerLevel(this.careerLevel + 1);
        } else {
            this.careerLevel = 1;
        }
        if (this.trades == null) {
            this.trades = new MerchantRecipeList();
        }
        if ((trades = this.getCareer().getTradesForLevel(this.careerLevel)) != null && trades.size() > 0) {
            Collections.shuffle(trades, this.field_70146_Z);
            if (this.careerLevel == 1 && trades.size() > 1) {
                for (Trade trade : trades.subList(0, 2)) {
                    this.trades.add((Object)trade.randomize(this.field_70146_Z));
                }
            } else {
                this.trades.add((Object)((Trade)trades.get(0)).randomize(this.field_70146_Z));
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151057_cb) {
            stack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (!this.func_190669_a(stack, ((Object)((Object)this)).getClass()) && this.func_70089_S() && !this.isTrading() && !this.func_70631_g_()) {
            if (this.trades == null) {
                this.populateTradeList();
            }
            if (!this.field_70170_p.field_72995_K && !this.trades.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            } else if (this.trades.isEmpty()) {
                return super.func_184645_a(player, hand);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_174820_d(int slot, ItemStack stack) {
        if (super.func_174820_d(slot, stack)) {
            return true;
        }
        int i = slot - 300;
        if (i >= 0 && i < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    private boolean canPickupItem(Item item) {
        return item == Item.func_150898_a((Block)NetherExBlocks.BROWN_ELDER_MUSHROOM) || item == Item.func_150898_a((Block)NetherExBlocks.RED_ELDER_MUSHROOM) || item == NetherExItems.ENOKI_MUSHROOM;
    }

    public boolean canAbandonItems() {
        return this.hasEnoughItems(2);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    private boolean hasEnoughItems(int multiplier) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || (stack.func_77973_b() != Item.func_150898_a((Block)NetherExBlocks.BROWN_ELDER_MUSHROOM) && stack.func_77973_b() != Item.func_150898_a((Block)NetherExBlocks.RED_ELDER_MUSHROOM) || stack.func_190916_E() < 4 * multiplier) && (stack.func_77973_b() != NetherExItems.ENOKI_MUSHROOM || stack.func_190916_E() < 32 * multiplier)) continue;
            return true;
        }
        return false;
    }

    public boolean wantsMoreFood() {
        boolean wantsMore;
        boolean bl = wantsMore = this.getProfession() == NetherExPigtificates.LEADER;
        return wantsMore ? !this.hasEnoughItems(5) : !this.hasEnoughItems(1);
    }

    public boolean isTrading() {
        return this.customer != null;
    }

    public boolean isMating() {
        return this.mating;
    }

    public boolean isWillingToMate(boolean updateFirst) {
        if (!this.willingToMate && updateFirst && this.hasEnoughItems(1)) {
            boolean flag = false;
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (!stack.func_190926_b()) {
                    if ((stack.func_77973_b() == Item.func_150898_a((Block)NetherExBlocks.BROWN_ELDER_MUSHROOM) || stack.func_77973_b() == Item.func_150898_a((Block)NetherExBlocks.RED_ELDER_MUSHROOM)) && stack.func_190916_E() >= 4) {
                        flag = true;
                        this.inventory.func_70298_a(i, 3);
                    } else if (stack.func_77973_b() == NetherExItems.ENOKI_MUSHROOM && stack.func_190916_E() >= 24) {
                        flag = true;
                        this.inventory.func_70298_a(i, 12);
                    }
                }
                if (!flag) continue;
                this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                this.willingToMate = true;
                break;
            }
        }
        return this.willingToMate;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean useAlternateTexture() {
        return false;
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.81f : 1.62f;
    }

    public InventoryBasic getInventory() {
        return this.inventory;
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public PigtificateProfession getProfession() {
        return (PigtificateProfession)NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValue(new ResourceLocation((String)this.field_70180_af.func_187225_a(PROFESSION)));
    }

    public PigtificateProfession.Career getCareer() {
        return (PigtificateProfession.Career)this.getProfession().getCareer(Math.max((Integer)this.field_70180_af.func_187225_a(CAREER), 0));
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.trades == null) {
            this.populateTradeList();
        }
        return this.trades;
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return I18n.func_74838_a((String)("entity." + this.getProfession().getName().func_110624_b() + ":pigtificate_" + this.getCareer().getName().func_110623_a().toLowerCase(Locale.ENGLISH) + ".name"));
    }

    protected ResourceLocation func_184647_J() {
        return this.getCareer().getLootTable();
    }

    protected SoundEvent func_184639_G() {
        return NetherExSoundEvents.PIGTIFICATE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.PIGTIFICATE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.PIGTIFICATE_DEATH;
    }

    public void setProfession(PigtificateProfession profession) {
        if (profession != null) {
            this.field_70180_af.func_187227_b(PROFESSION, (Object)profession.getName().toString());
        } else {
            ArrayList<PigtificateProfession> professions = new ArrayList<PigtificateProfession>(NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection());
            professions.removeIf(pigtificateProfession -> pigtificateProfession == NetherExPigtificates.LEADER);
            this.setProfession((PigtificateProfession)((Object)professions.toArray()[this.field_70146_Z.nextInt(professions.size())]));
        }
    }

    public void setCareer(PigtificateProfession.Career career) {
        if (this.getProfession() == career.getProfession()) {
            this.field_70180_af.func_187227_b(CAREER, (Object)career.getId());
        }
    }

    public void setRandomProfessionAndCareer() {
        ArrayList<PigtificateProfession> professions = new ArrayList<PigtificateProfession>(NetherExRegistries.PIGTIFICATE_PROFESSIONS.getValuesCollection());
        professions.removeIf(profession -> profession == NetherExPigtificates.LEADER);
        this.setProfession((PigtificateProfession)((Object)professions.toArray()[this.field_70146_Z.nextInt(professions.size())]));
        this.setCareer((PigtificateProfession.Career)this.getProfession().getRandomCareer(this.field_70146_Z));
    }

    public void setCareerLevel(int careerLevel) {
        if (careerLevel < 0) {
            careerLevel = 0;
        }
        this.careerLevel = careerLevel;
    }

    private void setAdditionalAITasks() {
        if (!this.additionalTasksSet) {
            this.additionalTasksSet = true;
            if (this.func_70631_g_()) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIPigtificatePlay(this, 0.32));
            }
        }
    }

    public void setLookingForHome() {
        this.lookingForHome = true;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(MerchantRecipeList tradeList) {
    }

    public void setWillingToMate(boolean willingToMate) {
        this.willingToMate = willingToMate;
    }

    public void setMating(boolean mating) {
        this.mating = mating;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public void func_70604_c(EntityLivingBase entity) {
        super.func_70604_c(entity);
        if (this.village != null && entity != null) {
            this.village.setAggressor(entity);
            if (entity instanceof EntityPlayer) {
                int i = -1;
                if (this.func_70631_g_()) {
                    i = -3;
                }
                this.village.modifyPlayerReputation(entity.func_110124_au(), i);
                if (this.func_70089_S()) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                }
            }
        }
    }

    private class PathNavigatePigtificate
    extends PathNavigateGround {
        private PathNavigatePigtificate(EntityLiving entity, World world) {
            super(entity, world);
        }

        protected PathFinder func_179679_a() {
            this.field_179695_a = new NodeProcessorPigtificate();
            this.field_179695_a.func_186321_b(true);
            this.field_179695_a.func_186317_a(true);
            return new PathFinder(this.field_179695_a);
        }

        private class NodeProcessorPigtificate
        extends WalkNodeProcessor {
            private NodeProcessorPigtificate() {
            }

            protected PathNodeType func_189553_b(IBlockAccess world, int posX, int posY, int posZ) {
                BlockPos pos = new BlockPos(posX, posY, posZ);
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                Material material = state.func_185904_a();
                PathNodeType type = block.getAiPathNodeType(state, world, pos);
                if (type != null) {
                    return type;
                }
                if (material == Material.field_151579_a) {
                    return PathNodeType.OPEN;
                }
                if (block != Blocks.field_150415_aT && block != Blocks.field_180400_cw && block != Blocks.field_150392_bi) {
                    if (block == Blocks.field_150480_ab) {
                        return PathNodeType.DAMAGE_FIRE;
                    }
                    if (block == Blocks.field_150434_aF) {
                        return PathNodeType.DAMAGE_CACTUS;
                    }
                    if (block instanceof BlockDoor && material == Material.field_151575_d && !((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() || block instanceof BlockFenceGate && !((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
                        return PathNodeType.DOOR_WOOD_CLOSED;
                    }
                    if (block instanceof BlockDoor && material == Material.field_151573_f && !((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue()) {
                        return PathNodeType.DOOR_IRON_CLOSED;
                    }
                    if (block instanceof BlockDoor && ((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b)).booleanValue() || block instanceof BlockFenceGate && ((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
                        return PathNodeType.DOOR_OPEN;
                    }
                    if (block instanceof BlockRailBase) {
                        return PathNodeType.RAIL;
                    }
                    if (!(block instanceof BlockFence) && !(block instanceof BlockWall)) {
                        if (material == Material.field_151586_h) {
                            return PathNodeType.WATER;
                        }
                        if (material == Material.field_151587_i) {
                            return PathNodeType.LAVA;
                        }
                        return block.func_176205_b(world, pos) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
                    }
                    return PathNodeType.FENCE;
                }
                return PathNodeType.TRAPDOOR;
            }
        }
    }
}

