/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.screen;

import ht.treechop.client.Client;
import ht.treechop.client.KeyBindings;
import ht.treechop.client.gui.IGuiEventListener;
import ht.treechop.client.gui.element.ButtonGui;
import ht.treechop.client.gui.element.EmptyGui;
import ht.treechop.client.gui.element.ExclusiveButtonsGui;
import ht.treechop.client.gui.element.LabeledGui;
import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.element.RowsGui;
import ht.treechop.client.gui.element.TextButtonGui;
import ht.treechop.client.gui.element.ToggleGui;
import ht.treechop.client.gui.screen.Screen;
import ht.treechop.client.gui.util.Sprite;
import ht.treechop.client.gui.widget.StickyWidget;
import ht.treechop.client.gui.widget.ToggleWidget;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.settings.Setting;
import ht.treechop.common.settings.SettingsField;
import ht.treechop.common.settings.SneakBehavior;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ClientSettingsScreen
extends Screen {
    private static final int ROW_SEPARATION = 1;
    private static final boolean IS_PAUSE_SCREEN = true;
    private static final int SPACE_ABOVE_AND_BELOW_LIST = 20;
    private static final int MIN_HEIGHT = 83;
    protected RowsGui optionsList;
    private NestedGui doneButton;
    private int optionsPage = 0;
    private boolean needToRebuild = false;
    private final List<NestedGui> children = new LinkedList<NestedGui>();

    public void func_73866_w_() {
        super.func_73866_w_();
        this.rebuild();
    }

    private void rebuild() {
        this.children.clear();
        List<NestedGui> optionRows = this.optionsPage == 0 ? this.makePageOne() : this.makePageTwo();
        this.addBufferRows(optionRows);
        optionRows.add(new ButtonGui(this.optionsPage == 0 ? Sprite.PAGE_ONE : Sprite.PAGE_TWO, this.optionsPage == 0 ? Sprite.HIGHLIGHTED_PAGE_ONE : Sprite.HIGHLIGHTED_PAGE_TWO, () -> {
            this.needToRebuild = true;
            this.optionsPage = this.optionsPage == 0 ? 1 : 0;
        }));
        this.optionsList = (RowsGui)this.addListener(new RowsGui(1, optionRows));
        int doneButtonWidth = 200;
        this.doneButton = this.addListener(new TextButtonGui((this.field_146294_l - 200) / 2, this.getDoneButtonTop(), 200, 20, new TextComponentTranslation("gui.done", new Object[0]), ClientSettingsScreen::closeScreen));
    }

    public static void closeScreen() {
        if (Minecraft.func_71410_x().field_71462_r instanceof ClientSettingsScreen) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    private NestedGui addListener(NestedGui gui) {
        this.children.add(gui);
        return gui;
    }

    private void addBufferRows(List<NestedGui> rows) {
        int missingHeight = 83 - RowsGui.getHeightForRows(rows, 1) - 2;
        if (missingHeight > 0) {
            rows.add(0, new EmptyGui(0, Math.floorDiv(missingHeight, 2)));
            rows.add(new EmptyGui(0, (int)Math.ceil((float)missingHeight / 2.0f)));
        }
    }

    private List<NestedGui> makePageOne() {
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(this.field_146289_q, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.chopping", new Object[0]), this.makeToggleSettingRow(SettingsField.CHOPPING)));
        if (ConfigHandler.CLIENT.showFellingOptions.get()) {
            optionRows.add(new LabeledGui(this.field_146289_q, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.felling", new Object[0]), this.makeToggleSettingRow(SettingsField.FELLING)));
            optionRows.add(new LabeledGui(this.field_146289_q, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.sneaking_inverts", new Object[0]), new ExclusiveButtonsGui.Builder().add((ITextComponent)new TextComponentTranslation("treechop.gui.settings.button.chopping", new Object[0]), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.INVERT_CHOPPING), () -> StickyWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.CHOPPING, !Client.getChopSettings().getChoppingEnabled()) && this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.INVERT_CHOPPING))).add((ITextComponent)new TextComponentTranslation("treechop.gui.settings.button.felling", new Object[0]), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.INVERT_FELLING), () -> StickyWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_FELLING, this.isSettingPermitted(SettingsField.FELLING, !Client.getChopSettings().getFellingEnabled()) && this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.INVERT_FELLING))).add((ITextComponent)new TextComponentTranslation("treechop.gui.settings.button.nothing", new Object[0]), () -> Client.getChopSettings().setSneakBehavior(SneakBehavior.NONE), () -> this.makeStickyWidgetState(SettingsField.SNEAK_BEHAVIOR, (Object)SneakBehavior.NONE)).build()));
        } else {
            optionRows.add(new LabeledGui(this.field_146289_q, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.sneaking_inverts_chopping", new Object[0]), new ToggleGui(() -> Client.getChopSettings().setSneakBehavior(this.getNextSneakBehavior()), () -> ToggleWidget.State.of(Client.getChopSettings().getSneakBehavior() == SneakBehavior.INVERT_CHOPPING, this.isSettingPermitted(SettingsField.SNEAK_BEHAVIOR, (Object)this.getNextSneakBehavior())))));
        }
        optionRows.add(new LabeledGui(this.field_146289_q, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.only_chop_trees_with_leaves", new Object[0]), this.makeToggleSettingRow(SettingsField.TREES_MUST_HAVE_LEAVES)));
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
            optionRows.add(new LabeledGui(this.field_146289_q, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.chop_in_creative_mode", new Object[0]), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE)));
        }
        return optionRows;
    }

    private LinkedList<NestedGui> makePageTwo() {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        LinkedList<NestedGui> optionRows = new LinkedList<NestedGui>();
        optionRows.add(new LabeledGui(fontRenderer, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.chop_in_creative_mode", new Object[0]), this.makeToggleSettingRow(SettingsField.CHOP_IN_CREATIVE_MODE)));
        optionRows.add(new LabeledGui(fontRenderer, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.chopping_indicator", new Object[0]), new ToggleGui(() -> Client.setChoppingIndicatorVisibility(!Client.isChoppingIndicatorEnabled()), () -> ToggleWidget.State.of(Client.isChoppingIndicatorEnabled(), true))));
        optionRows.add(new LabeledGui(fontRenderer, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.feedback_messages", new Object[0]), new ToggleGui(() -> ConfigHandler.CLIENT.showFeedbackMessages.set(!ConfigHandler.CLIENT.showFeedbackMessages.get()), () -> ToggleWidget.State.of(ConfigHandler.CLIENT.showFeedbackMessages.get(), true))));
        optionRows.add(new LabeledGui(fontRenderer, (ITextComponent)new TextComponentTranslation("treechop.gui.settings.label.felling_options", new Object[0]), new ToggleGui(() -> ConfigHandler.CLIENT.showFellingOptions.set(!ConfigHandler.CLIENT.showFellingOptions.get()), () -> ToggleWidget.State.of(ConfigHandler.CLIENT.showFellingOptions.get(), Client.getServerPermissions().isPermitted(new Setting(SettingsField.FELLING, false))))));
        return optionRows;
    }

    @Override
    public List<? extends IGuiEventListener> getEventListeners() {
        return this.children;
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        KeyBindings.buttonPressed();
    }

    private SneakBehavior getNextSneakBehavior() {
        return Client.getChopSettings().getSneakBehavior() == SneakBehavior.NONE ? SneakBehavior.INVERT_CHOPPING : SneakBehavior.NONE;
    }

    private ToggleGui makeToggleSettingRow(SettingsField field) {
        return new ToggleGui(() -> Client.getChopSettings().set(field, Client.getChopSettings().get(field, Boolean.class) == false), () -> ToggleWidget.State.of(Client.getChopSettings().get(field, Boolean.class), Client.getServerPermissions().isPermitted(new Setting(field, Client.getChopSettings().get(field, Boolean.class) == false))));
    }

    private boolean isSettingPermitted(SettingsField field, Object value) {
        return Client.getServerPermissions().isPermitted(new Setting(field, value));
    }

    private StickyWidget.State makeStickyWidgetState(SettingsField field, Object value) {
        return StickyWidget.State.of(Client.getChopSettings().get(field) == value, Client.getServerPermissions().isPermitted(new Setting(field, value)));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.needToRebuild) {
            this.func_73866_w_();
            this.needToRebuild = false;
        }
        this.renderBackground();
        int listTop = this.getListTop();
        int listBottom = this.getListBottom();
        this.optionsList.setBox(0, listTop, this.field_146294_l, listBottom - listTop);
        this.optionsList.render(mouseX, mouseY, partialTicks);
        this.doneButton.getBox().setTop(this.getDoneButtonTop());
        this.doneButton.render(mouseX, mouseY, partialTicks);
        String title = I18n.func_135052_a((String)"treechop.gui.settings.title", (Object[])new Object[]{"HT's TreeChop"});
        this.func_73731_b(this.field_146289_q, title, (this.field_146294_l - this.field_146289_q.func_78256_a(title)) / 2, this.getTitleTop(), 0xFFFFFF);
    }

    public void renderBackground() {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
    }

    public boolean func_73868_f() {
        return true;
    }

    protected int getTop() {
        return 32;
    }

    protected int getBottom() {
        return this.field_146295_m - 32;
    }

    protected int getMiddleY() {
        return (this.getTop() + this.getBottom()) / 2;
    }

    protected int getTitleTop() {
        return this.getListTop() - 20 - 8;
    }

    protected int getListTop() {
        return this.getMiddleY() - this.getListHeight() / 2;
    }

    protected int getListHeight() {
        return this.optionsList.getHeight();
    }

    protected int getListBottom() {
        return this.getMiddleY() + this.getListHeight() / 2;
    }

    protected int getDoneButtonTop() {
        return this.getListBottom() + 20;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return true;
    }
}

