/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.config;

import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Rounder;
import java.util.function.Function;
import net.minecraft.util.IStringSerializable;

public enum ChopCountingAlgorithm implements IStringSerializable
{
    LINEAR(numBlocks -> {
        double x = numBlocks.intValue();
        double m = ConfigHandler.COMMON.linearM;
        double b = ConfigHandler.COMMON.linearB;
        return m * x + b;
    }),
    LOGARITHMIC(numBlocks -> {
        double x = numBlocks.intValue();
        double a = ConfigHandler.COMMON.logarithmicA;
        return 1.0 + a * Math.log(1.0 + (x - 1.0) / a);
    });

    private final Function<Integer, Double> preciseCalculation;

    private ChopCountingAlgorithm(Function<Integer, Double> preciseCalculation) {
        this.preciseCalculation = preciseCalculation;
    }

    public int calculate(int numBlocks) {
        if (numBlocks == 1) {
            return 1;
        }
        Rounder rounder = ConfigHandler.COMMON.chopCountRounding.get();
        int unboundedCount = Math.max(1, rounder.round(this.preciseCalculation.apply(numBlocks)));
        return ConfigHandler.COMMON.canRequireMoreChopsThanBlocks.get() ? unboundedCount : Math.min(numBlocks, unboundedCount);
    }

    public String func_176610_l() {
        return this.name();
    }
}

