/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.util;

import com.google.common.collect.Lists;
import ht.treechop.common.util.ChopUtil;
import ht.treechop.common.util.TreeBlock;
import ht.treechop.common.util.WorldBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ChopResult {
    public static final ChopResult IGNORED = new ChopResult(Lists.newArrayList(), false);
    private final List<TreeBlock> blocks;
    private final boolean felling;
    public static final int MAX_NUM_FELLING_EFFECTS = 32;

    public ChopResult(List<TreeBlock> blocks, boolean felling) {
        this.blocks = blocks;
        this.felling = felling;
    }

    public ChopResult(List<TreeBlock> blocks) {
        this(blocks, false);
    }

    public ChopResult(World world, Collection<BlockPos> chopPositions, Collection<BlockPos> fellPositions) {
        this(Stream.of(chopPositions, fellPositions).flatMap(Collection::stream).map(pos -> new TreeBlock(world, (BlockPos)pos, Blocks.field_150350_a.func_176223_P())).collect(Collectors.toList()), true);
    }

    public boolean apply(BlockPos targetPos, EntityPlayer agent, ItemStack tool, boolean breakLeaves) {
        World world = agent.func_130014_f_();
        AtomicBoolean somethingChanged = new AtomicBoolean(false);
        List logs = this.blocks.stream().filter(treeBlock -> !somethingChanged.get() && ChopUtil.canChangeBlock(treeBlock.getPos(), agent, treeBlock.wasChopped() ? tool : ItemStack.field_190927_a)).peek(treeBlock -> {
            IBlockState blockState = world.func_180495_p(treeBlock.getPos());
            somethingChanged.compareAndSet(false, blockState.func_177230_c().isAir(blockState, (IBlockAccess)world, treeBlock.getPos()));
        }).collect(Collectors.toList());
        if (somethingChanged.get()) {
            return false;
        }
        ArrayList leaves = this.felling && breakLeaves ? ChopUtil.getTreeLeaves(world, logs.stream().map(WorldBlock::getPos).collect(Collectors.toList())).stream().filter(pos -> ChopUtil.canChangeBlock(pos, agent, ItemStack.field_190927_a)).map(pos -> new TreeBlock(world, (BlockPos)pos, Blocks.field_150350_a.func_176223_P())).collect(Collectors.toList()) : Lists.newArrayList();
        int numLogsAndLeaves = logs.size() + leaves.size();
        if (!world.field_72995_K && !agent.func_184812_l_()) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
            int silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool);
            AtomicInteger xpAccumulator = new AtomicInteger(0);
            EntityPlayer fakePlayer = world instanceof WorldServer ? FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)) : agent;
            Stream.of(logs, leaves).flatMap(Collection::stream).forEach(treeBlock -> {
                if (treeBlock.wasChopped()) {
                    ChopResult.harvestWorldBlock(agent, tool, xpAccumulator, fortune, silkTouch, treeBlock);
                } else {
                    ChopResult.harvestWorldBlock(fakePlayer, ItemStack.field_190927_a, xpAccumulator, 0, 0, treeBlock);
                }
            });
            ChopUtil.dropExperience(world, targetPos, xpAccumulator.get());
        }
        int numEffects = Math.min((int)Math.ceil(Math.sqrt(numLogsAndLeaves)), 32) - 1;
        Collections.shuffle(logs);
        Collections.shuffle(leaves);
        int numLeavesEffects = Math.max(0, (int)Math.ceil((double)numEffects * ((double)leaves.size() / (double)numLogsAndLeaves)));
        int numLogsEffects = Math.max(0, numEffects - numLeavesEffects);
        Stream.of(logs.stream().limit(numLogsEffects), leaves.stream().limit(numLeavesEffects)).flatMap(a -> a).forEach(treeBlock -> world.func_175718_b(2001, treeBlock.getPos(), Block.func_176210_f((IBlockState)world.func_180495_p(treeBlock.getPos()))));
        Stream.of(logs, leaves).flatMap(Collection::stream).forEach(treeBlock -> treeBlock.getWorld().func_180501_a(treeBlock.getPos(), treeBlock.getState(), 3));
        return true;
    }

    private static void harvestWorldBlock(EntityPlayer agent, ItemStack tool, AtomicInteger totalXp, int fortune, int silkTouch, TreeBlock treeBlock) {
        World world = treeBlock.getWorld();
        BlockPos pos = treeBlock.getPos();
        IBlockState blockState = world.func_180495_p(pos);
        blockState.func_177230_c().func_180657_a(world, agent, pos, blockState, world.func_175625_s(pos), tool);
        totalXp.getAndAdd(blockState.func_177230_c().getExpDrop(blockState, (IBlockAccess)world, pos, fortune));
    }
}

