/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.advsolarpatch;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer
implements IClassTransformer {
    private static final Map<String, BiFunction<Integer, ClassVisitor, ClassVisitor>> TRANSFORMERS = new HashMap<String, BiFunction<Integer, ClassVisitor, ClassVisitor>>();

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (TRANSFORMERS.containsKey(name)) {
            ClassReader reader = new ClassReader(bytes);
            ClassWriter writer = new ClassWriter(reader, 3);
            reader.accept(TRANSFORMERS.get(name).apply(262144, (ClassVisitor)writer), 0);
            return writer.toByteArray();
        }
        return bytes;
    }

    static {
        TRANSFORMERS.put("com.chocohead.advsolar.tiles.TileEntityMolecularAssembler$1", InvSlotProcessableVisitor::new);
        TRANSFORMERS.put("com.chocohead.advsolar.tiles.TileEntityMolecularAssembler", MolecularAssemblerVisitor::new);
        TRANSFORMERS.put("com.chocohead.advsolar.slots.InvSlotMultiCharge", InvSlotMultiChargeVisitor::new);
        TRANSFORMERS.put("com.chocohead.advsolar.items.ItemDoubleSlab", ItemDoubleSlabVisitor::new);
    }

    private static class ItemDoubleSlabVisitor
    extends ClassVisitor {
        private final String methodCanPlayerEditName;
        private final String methodGetMetadataName;
        private final String fieldBlock;

        public ItemDoubleSlabVisitor(int api, ClassVisitor cv) {
            super(api, cv);
            boolean deobf = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
            this.methodCanPlayerEditName = deobf ? "canPlayerEdit" : "func_175151_a";
            this.methodGetMetadataName = deobf ? "getMetadata" : "func_77960_j";
            this.fieldBlock = deobf ? "block" : "field_150939_a";
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new ItemDoubleSlabMethodVisitor(262144, super.visitMethod(access, name, desc, signature, exceptions));
        }

        private class ItemDoubleSlabMethodVisitor
        extends MethodVisitor {
            private boolean replaceInsn;

            public ItemDoubleSlabMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 182 && owner.equals("net/minecraft/entity/player/EntityPlayer") && name.equals(ItemDoubleSlabVisitor.this.methodCanPlayerEditName) && desc.equals("(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/item/ItemStack;)Z") && !itf) {
                    this.replaceInsn = true;
                } else if (opcode == 182 && owner.equals("net/minecraft/item/ItemStack") && name.equals(ItemDoubleSlabVisitor.this.methodGetMetadataName) && desc.equals("()I") && !itf) {
                    this.replaceInsn = false;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }

            public void visitVarInsn(int opcode, int var) {
                if (this.replaceInsn && opcode == 25 && var == 10) {
                    this.visitVarInsn(25, 0);
                    this.visitFieldInsn(180, "net/minecraft/item/ItemBlock", ItemDoubleSlabVisitor.this.fieldBlock, "Lnet/minecraft/block/Block;");
                } else {
                    super.visitVarInsn(opcode, var);
                }
            }
        }
    }

    private static class InvSlotMultiChargeVisitor
    extends ClassVisitor {
        public InvSlotMultiChargeVisitor(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new InvSlotMultiChargeMethodVisitor(262144, super.visitMethod(access, name, desc, signature, exceptions));
        }

        private static class InvSlotMultiChargeMethodVisitor
        extends MethodVisitor {
            public InvSlotMultiChargeMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 183 && owner.equals("ic2/core/block/invslot/InvSlot") && name.equals("<init>") && desc.equals("(Lic2/core/block/TileEntityInventory;Ljava/lang/String;Lic2/core/block/invslot/InvSlot$Access;ILic2/core/block/invslot/InvSlot$InvSide;)V") && !itf) {
                    super.visitMethodInsn(opcode, owner, name, desc.replace("ic2/core/block/TileEntityInventory", "ic2/core/block/IInventorySlotHolder"), false);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }
    }

    private static class MolecularAssemblerVisitor
    extends ClassVisitor {
        public MolecularAssemblerVisitor(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new MolecularAssemblerMethodVisitor(262144, super.visitMethod(access, name, desc, signature, exceptions));
        }

        private static class MolecularAssemblerMethodVisitor
        extends MethodVisitor {
            public MolecularAssemblerMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 183 && owner.equals("ic2/core/block/invslot/InvSlotOutput") && name.equals("<init>") && desc.equals("(Lic2/core/block/TileEntityInventory;Ljava/lang/String;I)V") && !itf) {
                    super.visitMethodInsn(opcode, owner, name, desc.replace("ic2/core/block/TileEntityInventory", "ic2/core/block/IInventorySlotHolder"), false);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }
    }

    private static class InvSlotProcessableVisitor
    extends ClassVisitor {
        public InvSlotProcessableVisitor(int api, ClassVisitor cv) {
            super(api, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new InvSlotProcessableMethodVisitor(262144, super.visitMethod(access, name, desc, signature, exceptions));
        }

        private static class InvSlotProcessableMethodVisitor
        extends MethodVisitor {
            public InvSlotProcessableMethodVisitor(int api, MethodVisitor mv) {
                super(api, mv);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (opcode == 183 && owner.equals("ic2/core/block/invslot/InvSlotProcessable") && name.equals("<init>") && desc.equals("(Lic2/core/block/TileEntityInventory;Ljava/lang/String;ILic2/api/recipe/IMachineRecipeManager;)V") && !itf) {
                    super.visitMethodInsn(opcode, owner, name, desc.replace("ic2/core/block/TileEntityInventory", "ic2/core/block/IInventorySlotHolder"), false);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        }
    }
}

