/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.item;

import com.google.common.collect.Multimap;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.api.item.IItemWolfArmor;
import dev.satyrn.wolfarmor.api.item.IWolfArmorMaterial;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class ItemWolfArmor
extends Item
implements IItemWolfArmor {
    private static final String NBT_TAG_DISPLAY = "Display";
    private static final String NBT_TAG_COLOR = "Color";
    private static final IBehaviorDispenseItem DISPENSE_ITEM = new BehaviorDefaultDispenseItem(){

        @Nonnull
        protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
            ItemStack itemStack = ItemWolfArmor.dispenseWolfArmor(source, stack);
            return !itemStack.func_190926_b() ? itemStack : super.func_82487_b(source, stack);
        }
    };
    private final IWolfArmorMaterial material;

    public ItemWolfArmor(IWolfArmorMaterial material) {
        this.material = material;
        this.field_77777_bU = 1;
        this.canRepair = true;
        this.func_77656_e(material.getDurability());
        this.func_77637_a(CreativeTabs.field_78026_f);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSE_ITEM);
    }

    public void removeColor(@Nonnull ItemStack stack) {
        NBTTagCompound stackCompound;
        if (!stack.func_190926_b() && this.getMaterial().getCanBeDyed() && this.getHasColor(stack) && (stackCompound = stack.func_77978_p()) != null) {
            stackCompound.func_74775_l(NBT_TAG_DISPLAY).func_82580_o(NBT_TAG_COLOR);
        }
    }

    public IWolfArmorMaterial getMaterial() {
        return this.material;
    }

    public boolean getHasOverlay(@Nonnull ItemStack stack) {
        return this.getMaterial().getHasOverlay() || this.getColor(stack) != -1;
    }

    public boolean getHasColor(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound;
        if (!stack.func_190926_b() && this.getMaterial().getCanBeDyed() && stack.func_77942_o() && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_74764_b(NBT_TAG_DISPLAY)) {
            NBTTagCompound display = tagCompound.func_74775_l(NBT_TAG_DISPLAY);
            return display.func_74764_b(NBT_TAG_COLOR);
        }
        return false;
    }

    public int getColor(@Nonnull ItemStack stack) {
        NBTTagCompound display;
        if (!this.getMaterial().getCanBeDyed() || stack.func_190926_b()) {
            return -1;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && (display = tagCompound.func_74775_l(NBT_TAG_DISPLAY)).func_74764_b(NBT_TAG_COLOR)) {
            return display.func_74762_e(NBT_TAG_COLOR);
        }
        return this.getMaterial().getDefaultColor();
    }

    public void setColor(@Nonnull ItemStack stack, int color) {
        if (!this.getMaterial().getCanBeDyed()) {
            throw new UnsupportedOperationException("Wolf armor material is not dyeable!");
        }
        if (!stack.func_190926_b()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            NBTTagCompound display = tagCompound.func_74775_l(NBT_TAG_DISPLAY);
            if (!tagCompound.func_74764_b(NBT_TAG_DISPLAY)) {
                tagCompound.func_74782_a(NBT_TAG_DISPLAY, (NBTBase)display);
            }
            display.func_74768_a(NBT_TAG_COLOR, color);
        }
    }

    @Deprecated
    public double getDamageReductionAmount() {
        return this.getMaterial().getDamageReductionAmount();
    }

    @Nonnull
    private static ItemStack dispenseWolfArmor(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        BlockPos blockPos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        List wolves = source.func_82618_k().func_72872_a(EntityWolf.class, new AxisAlignedBB(blockPos));
        if (!wolves.isEmpty()) {
            EntityWolf wolf = null;
            for (EntityWolf entity : wolves) {
                if (!entity.func_70909_n() || entity.func_70631_g_()) continue;
                wolf = entity;
                break;
            }
            if (wolf != null) {
                ItemStack copyStack = stack.func_77946_l();
                copyStack.func_190920_e(1);
                IArmoredWolf wolfArmor = (IArmoredWolf)wolf;
                if (!wolfArmor.canEquipItem(copyStack)) {
                    return stack;
                }
                wolfArmor.equipArmor(copyStack);
                stack.func_190918_g(1);
            }
        }
        return stack;
    }

    public int func_77619_b() {
        return this.getMaterial().getEnchantability();
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_191530_r) {
            return false;
        }
        return enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE || enchantment.field_77351_y == EnumEnchantmentType.WEAPON || enchantment.field_77351_y == EnumEnchantmentType.ARMOR || enchantment.field_77351_y == EnumEnchantmentType.ARMOR_FEET;
    }

    public boolean func_82789_a(@Nonnull ItemStack originalStack, @Nonnull ItemStack repairStack) {
        return this.getMaterial().getRepairItem() == repairStack.func_77973_b() || super.func_82789_a(originalStack, repairStack);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, @Nonnull ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.CHEST && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemWolfArmor) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_UUID, "Armor modifier", this.getMaterial().getDamageReductionAmount(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_UUID, "Armor toughness", (double)this.getMaterial().getToughness(), 0));
        }
        return multimap;
    }
}

