/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.mixin;

import com.google.common.collect.Multimap;
import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.advancements.WolfArmorTrigger;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.api.item.IItemWolfArmor;
import dev.satyrn.wolfarmor.api.util.CreatureFoodStats;
import dev.satyrn.wolfarmor.api.util.Criteria;
import dev.satyrn.wolfarmor.api.util.DataHelper;
import dev.satyrn.wolfarmor.api.util.Items;
import dev.satyrn.wolfarmor.common.network.MessageBase;
import dev.satyrn.wolfarmor.common.network.packets.RemovePotionEffectMessage;
import dev.satyrn.wolfarmor.common.network.packets.UpdateFoodStatsMessage;
import dev.satyrn.wolfarmor.common.network.packets.UpdatePotionEffectMessage;
import dev.satyrn.wolfarmor.config.WolfArmorConfig;
import dev.satyrn.wolfarmor.item.ItemWolfArmor;
import dev.satyrn.wolfarmor.mixin.MixinEntityTameable;
import dev.satyrn.wolfarmor.mixin.accessors.EntityLivingAccessor;
import dev.satyrn.wolfarmor.util.OreDictHelper;
import dev.satyrn.wolfarmor.util.WolfFoodStatsLevel;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityWolf.class})
public abstract class MixinEntityWolf
extends MixinEntityTameable
implements IArmoredWolf {
    private int entityXpCooldown;
    private ContainerHorseChest inventory;
    private CreatureFoodStats foodStats;
    private WolfArmorConfig config;
    private SimpleNetworkWrapper connection;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.config = WolfArmorMod.getConfig();
        this.connection = WolfArmorMod.getNetworkChannel();
        float minimumHealth = this.config.getCanStarve() ? 0.0f : 8.0f;
        boolean damageEntity = this.config.getFoodStatsLevel() == WolfFoodStatsLevel.FULL;
        this.foodStats = new CreatureFoodStats(minimumHealth, damageEntity);
        this.inventoryInit();
    }

    @Override
    @Nonnull
    public CreatureFoodStats getFoodStats() {
        return this.foodStats;
    }

    @Override
    public void addExhaustion(float exhaustion) {
        if (this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED && this.foodStats != null && !this.func_130014_f_().field_72995_K) {
            this.foodStats.addExhaustion(exhaustion);
        }
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        ItemStack armorItemStack = invBasic.func_70301_a(0);
        this.setArmorItemStack(armorItemStack);
        this.applyArmorModifiers(this.func_110148_a(SharedMonsterAttributes.field_188791_g), armorItemStack);
        this.applyArmorModifiers(this.func_110148_a(SharedMonsterAttributes.field_189429_h), armorItemStack);
    }

    @Override
    public Item getChestType() {
        ItemStack chestType = (ItemStack)this.field_70180_af.func_187225_a(DataHelper.CHEST_TYPE);
        return chestType.func_190926_b() ? null : chestType.func_77973_b();
    }

    @Override
    public void setChestType(@Nonnull ItemStack stack) {
        ItemStack chestType = stack.func_77946_l();
        if (!chestType.func_190926_b()) {
            chestType.func_190920_e(1);
        }
        this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)chestType);
    }

    @Override
    public boolean getHasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(DataHelper.HAS_CHEST);
    }

    @Override
    public void setHasChest(boolean hasChest) {
        this.field_70180_af.func_187227_b(DataHelper.HAS_CHEST, (Object)hasChest);
        if (!hasChest) {
            this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public int getMaxSizeInventory() {
        return 1 + this.config.getChestSize().getColumns() * this.config.getChestSize().getRows();
    }

    @Override
    @Nonnull
    public InventoryBasic getInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public ItemStack getArmorItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(DataHelper.ARMOR_ITEM);
    }

    @Override
    public void setArmorItemStack(@Nonnull ItemStack armorItemStack) {
        if (armorItemStack != this.field_70180_af.func_187225_a(DataHelper.ARMOR_ITEM)) {
            this.field_70180_af.func_187227_b(DataHelper.ARMOR_ITEM, (Object)armorItemStack);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, armorItemStack);
            this.func_184201_a(EntityEquipmentSlot.HEAD, armorItemStack);
            this.func_184201_a(EntityEquipmentSlot.CHEST, armorItemStack);
            this.func_184201_a(EntityEquipmentSlot.LEGS, armorItemStack);
            this.func_184201_a(EntityEquipmentSlot.FEET, armorItemStack);
            Arrays.fill(((EntityLivingAccessor)((Object)this)).getInventoryArmorDropChances(), 0.0f);
            Arrays.fill(((EntityLivingAccessor)((Object)this)).getInventoryHandsDropChances(), 0.0f);
        }
    }

    @Override
    public boolean getHasArmor() {
        return !this.getArmorItemStack().func_190926_b();
    }

    @Override
    public boolean canEquipItem(@Nonnull ItemStack armorItemStack) {
        return armorItemStack.func_190926_b() || !this.getHasArmor() && armorItemStack.func_77973_b() instanceof ItemWolfArmor;
    }

    @Override
    public void equipArmor(@Nonnull ItemStack armorItemStack) {
        if (this.canEquipItem(armorItemStack)) {
            this.inventory.func_70299_a(0, armorItemStack);
        }
    }

    @Override
    public void setInventoryItem(int index, @Nonnull ItemStack itemStack) {
        if (index >= 0 && index < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(index, itemStack);
        } else {
            WolfArmorMod.getLogger().log(Level.ERROR, String.format("Invalid slot: %d", index));
        }
    }

    @Override
    public void dropEquipment() {
        if (this.getHasArmor()) {
            ItemStack armorItemStack = this.getArmorItemStack();
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70099_a(armorItemStack, 0.0f);
            }
            this.equipArmor(ItemStack.field_190927_a);
        }
    }

    @Override
    public void dropChest() {
        if (this.getHasChest()) {
            if (!this.func_130014_f_().field_72995_K) {
                Item chestItem = this.getChestType();
                this.func_70099_a(new ItemStack(chestItem == null ? Item.func_150898_a((Block)Blocks.field_150486_ae) : chestItem, 1), 0.0f);
            }
            this.setHasChest(false);
        }
    }

    @Override
    public void dropInventoryContents() {
        for (int slotIndex = 1; slotIndex <= this.getMaxSizeInventory() - 1; ++slotIndex) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70099_a(stackInSlot, 0.0f);
            }
            this.setInventoryItem(slotIndex, ItemStack.field_190927_a);
        }
    }

    @Shadow
    public abstract boolean func_70919_bu();

    @Override
    @Intrinsic
    protected void func_70675_k(float damage) {
        ItemStack stackInSlot;
        super.func_70675_k(damage);
        if (this.getHasArmor() && !(stackInSlot = this.inventory.func_70301_a(0)).func_190926_b()) {
            stackInSlot.func_77972_a((int)Math.ceil(damage), (EntityLivingBase)this);
            if (stackInSlot.func_190916_E() == 0) {
                ItemStack particleStack = stackInSlot.func_77946_l();
                particleStack.func_190920_e(1);
                this.equipArmor(ItemStack.field_190927_a);
                this.func_70669_a(particleStack);
            }
        }
    }

    @Override
    @Intrinsic
    public void func_191986_a(float strafe, float vertical, float forward) {
        double initX = this.field_70165_t;
        double initY = this.field_70163_u;
        double initZ = this.field_70161_v;
        super.func_191986_a(strafe, vertical, forward);
        this.addMovementStat(this.field_70165_t - initX, this.field_70163_u - initY, this.field_70161_v - initZ);
    }

    @Override
    @Intrinsic
    protected void func_70670_a(PotionEffect effect) {
        super.func_70670_a(effect);
        if (!this.func_130014_f_().field_72995_K) {
            this.dispatchPotionEffectMessage(effect, false);
        }
    }

    @Override
    @Intrinsic
    protected void func_70695_b(PotionEffect effect, boolean sendUpdate) {
        super.func_70695_b(effect, sendUpdate);
        if (sendUpdate && !this.func_130014_f_().field_72995_K) {
            this.dispatchPotionEffectMessage(effect, false);
        }
    }

    @Override
    @Intrinsic
    protected void func_70688_c(PotionEffect effect) {
        super.func_70688_c(effect);
        if (!this.func_130014_f_().field_72995_K) {
            this.dispatchPotionEffectMessage(effect, true);
        }
    }

    @Override
    @Intrinsic
    public void func_70645_a(DamageSource damageSource) {
        this.dropEquipment();
        this.dropChest();
        this.dropInventoryContents();
        super.func_70645_a(damageSource);
    }

    @Inject(method={"attackEntityAsMob"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAttackEntityAsMob(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        boolean atkFlag;
        float damage = (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entityIn instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.getArmorItemStack(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockback += EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180313_o, (EntityLivingBase)((EntityLivingBase)this));
        }
        if (atkFlag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this)), damage)) {
            int fireAspect;
            if (knockback > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= (double)0.6f;
                this.field_70179_y *= (double)0.6f;
            }
            if ((fireAspect = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_77334_n, (EntityLivingBase)((EntityLivingBase)this))) > 0) {
                entityIn.func_70015_d(fireAspect * 4);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
            this.foodStats.addExhaustion(0.1f);
        }
        cir.setReturnValue(atkFlag);
        cir.cancel();
    }

    @Inject(method={"entityInit"}, at={@At(value="RETURN")})
    private void onEntityInit(CallbackInfo ci) {
        this.field_70180_af.func_187214_a(DataHelper.HAS_CHEST, (Object)false);
        this.field_70180_af.func_187214_a(DataHelper.ARMOR_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DataHelper.CHEST_TYPE, (Object)ItemStack.field_190927_a);
    }

    @Inject(method={"onUpdate"}, at={@At(value="TAIL")})
    private void onUpdate(CallbackInfo ci) {
        if (this.foodStats != null && this.func_70909_n() && !this.func_130014_f_().field_72995_K && this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED) {
            this.foodStats.onUpdate((EntityLivingBase)this);
            this.connection.sendToAll((IMessage)new UpdateFoodStatsMessage(this.func_145782_y(), this.foodStats.getFoodLevel(), this.foodStats.getSaturationLevel()));
        }
        --this.entityXpCooldown;
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="TAIL")})
    private void onLivingUpdate(CallbackInfo ci) {
        ItemStack enchantedItem;
        if (!this.field_70128_L && !this.func_130014_f_().field_72995_K && !(enchantedItem = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)((EntityLivingBase)this))).func_190926_b() && enchantedItem.func_77951_h()) {
            AxisAlignedBB aabb = this.func_184218_aH() && !this.func_184187_bx().field_70128_L ? this.func_174813_aQ().func_111270_a(this.func_184187_bx().func_174813_aQ()) : this.func_174813_aQ();
            List collidedEntities = this.func_130014_f_().func_72839_b((Entity)this, aabb);
            for (Entity entity : collidedEntities) {
                if (!(entity instanceof EntityXPOrb) || entity.field_70128_L) continue;
                EntityXPOrb xpOrb = (EntityXPOrb)entity;
                if (xpOrb.field_70532_c == 0 && this.entityXpCooldown == 0) {
                    float ratio = enchantedItem.func_77973_b().getXpRepairRatio(enchantedItem);
                    int repairAmount = Math.min(this.xpRoundAverage((float)xpOrb.field_70530_e * ratio), enchantedItem.func_77952_i());
                    xpOrb.field_70530_e -= this.xpRoundAverage((float)xpOrb.field_70530_e / ratio);
                    enchantedItem.func_77964_b(enchantedItem.func_77952_i() - repairAmount);
                    this.entityXpCooldown = 2;
                }
                if (xpOrb.field_70530_e != 0) continue;
                xpOrb.func_70106_y();
            }
        }
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetAmbientSound(CallbackInfoReturnable<SoundEvent> ci) {
        if (this.func_70919_bu() || !this.func_70909_n() || this.config.getFoodStatsLevel() == WolfFoodStatsLevel.DISABLED || this.foodStats == null) {
            return;
        }
        if (this.func_70681_au().nextInt(3) == 0 && (float)this.foodStats.getFoodLevel() + this.foodStats.getSaturationLevel() <= 18.0f) {
            ci.setReturnValue(SoundEvents.field_187871_gL);
            ci.cancel();
        }
    }

    @Inject(method={"writeEntityToNBT"}, at={@At(value="RETURN")})
    private void onWriteEntityToNBT(@Nonnull NBTTagCompound compound, CallbackInfo ci) {
        boolean hasChest = this.getHasChest();
        compound.func_74757_a("HasChest", hasChest);
        if (hasChest) {
            ItemStack chestInSlot = (ItemStack)this.field_70180_af.func_187225_a(DataHelper.CHEST_TYPE);
            NBTTagCompound chestItem = new NBTTagCompound();
            chestInSlot.func_77955_b(chestItem);
            compound.func_74782_a("ChestType", (NBTBase)chestItem);
            NBTTagList inventoryItems = new NBTTagList();
            InventoryBasic inventory = this.getInventory();
            for (byte slotIndex = 0; slotIndex < inventory.func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = inventory.func_70301_a((int)slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                NBTTagCompound stackInSlotTags = new NBTTagCompound();
                stackInSlotTags.func_74774_a("Slot", slotIndex);
                stackInSlot.func_77955_b(stackInSlotTags);
                inventoryItems.func_74742_a((NBTBase)stackInSlotTags);
            }
            compound.func_74782_a("Inventory", (NBTBase)inventoryItems);
        }
        if (this.getHasArmor()) {
            ItemStack armorItemStack = this.getArmorItemStack();
            if (!armorItemStack.func_190926_b()) {
                NBTTagCompound armorItemTag = armorItemStack.func_77955_b(new NBTTagCompound());
                compound.func_74782_a("ArmorItem", (NBTBase)armorItemTag);
            } else {
                compound.func_82580_o("ArmorItem");
            }
        }
        if (this.foodStats != null) {
            this.foodStats.writeNBT(compound);
        }
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="RETURN")})
    private void onReadEntityFromNBT(@Nonnull NBTTagCompound compound, CallbackInfo ci) {
        NBTTagCompound armorTags;
        NBTTagCompound capabilities;
        if (compound.func_74764_b("ForgeCaps") && (capabilities = compound.func_74775_l("ForgeCaps")).func_74764_b("wolfarmor:wolf_armor")) {
            this.processLegacyDataTags(capabilities.func_74775_l("wolfarmor:wolf_armor"));
            return;
        }
        boolean hasChest = compound.func_74767_n("HasChest");
        this.setHasChest(hasChest);
        if (hasChest) {
            this.inventoryInit();
            ItemStack chestTypeStack = new ItemStack(compound.func_74775_l("ChestType"));
            this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)chestTypeStack);
            NBTTagList inventoryTagList = compound.func_150295_c("Inventory", 10);
            for (int index = 0; index < inventoryTagList.func_74745_c(); ++index) {
                NBTTagCompound compoundTagAt = inventoryTagList.func_150305_b(index);
                byte slotIndex = compoundTagAt.func_74771_c("Slot");
                if (slotIndex >= 0 && slotIndex < this.inventory.func_70302_i_()) {
                    this.inventory.func_70299_a((int)slotIndex, new ItemStack(compoundTagAt));
                    continue;
                }
                WolfArmorMod.getLogger().log(Level.WARN, String.format("[NBT LOAD] Discarded invalid slot information at index %d", slotIndex));
            }
        }
        if (!(armorTags = compound.func_74775_l("ArmorItem")).func_82582_d()) {
            ItemStack armorItemStack = new ItemStack(armorTags);
            this.equipArmor(armorItemStack);
        }
        if (this.foodStats != null) {
            this.foodStats.readNBT(compound);
        }
    }

    @Inject(method={"processInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProcessInteract(EntityPlayer player, EnumHand hand, CallbackInfoReturnable<Boolean> cir) {
        if (player.func_70093_af() && this.func_152114_e((EntityLivingBase)player) && this.func_70909_n() && !this.func_70631_g_()) {
            this.openWolfInventory(player);
            cir.setReturnValue(true);
            cir.cancel();
            return;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (!itemStack.func_190926_b()) {
            if (this.config.getFoodStatsLevel() != WolfFoodStatsLevel.DISABLED && this.foodStats != null && itemStack.func_77973_b() instanceof ItemFood) {
                ItemFood foodItem = (ItemFood)itemStack.func_77973_b();
                cir.setReturnValue(false);
                if (foodItem.func_77845_h() || this.func_70877_b(itemStack)) {
                    if (foodItem.func_77845_h() && this.foodStats.needFood()) {
                        this.foodStats.addStats(foodItem, itemStack);
                        this.func_175505_a(player, itemStack);
                        cir.setReturnValue(true);
                    } else if (this.func_70877_b(itemStack)) {
                        if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                            this.func_175505_a(player, itemStack);
                            this.func_146082_f(player);
                            cir.setReturnValue(true);
                        } else if (this.func_70631_g_()) {
                            this.func_175505_a(player, itemStack);
                            this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                            cir.setReturnValue(true);
                        }
                    } else {
                        cir.setReturnValue(false);
                    }
                } else if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K) {
                    this.func_70904_g(!this.func_70906_o());
                    this.field_70703_bu = false;
                    this.func_70661_as().func_75499_g();
                    this.func_70624_b(null);
                }
                cir.cancel();
                return;
            }
            if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !this.func_70631_g_()) {
                if (this.config.getChestEnabled() && !this.getHasChest() && OreDictHelper.isOre(false, "chestWood", itemStack)) {
                    if (!this.func_130014_f_().field_72995_K) {
                        ItemStack chestItem = itemStack.func_77946_l();
                        chestItem.func_190920_e(1);
                        this.playEquipSound(chestItem);
                        this.setHasChest(true);
                        this.setChestType(chestItem);
                        this.func_175505_a(player, itemStack);
                        if (player instanceof EntityPlayerMP) {
                            ((WolfArmorTrigger)Criteria.EQUIP_WOLF_CHEST).trigger((EntityPlayerMP)player, (Entity)((EntityWolf)this));
                        }
                    }
                    cir.setReturnValue(true);
                    cir.cancel();
                    return;
                }
                if (Items.isValidWolfArmor(itemStack)) {
                    if (this.getArmorItemStack().func_190926_b()) {
                        ItemStack toEquip = itemStack.func_77946_l();
                        toEquip.func_190920_e(1);
                        this.equipArmor(toEquip);
                        this.func_175505_a(player, itemStack);
                    } else {
                        this.openWolfInventory(player);
                    }
                    cir.setReturnValue(true);
                    cir.cancel();
                }
            }
        }
    }

    private void applyArmorModifiers(@Nullable IAttributeInstance instance, @Nonnull ItemStack stack) {
        if (instance == null) {
            return;
        }
        instance.func_188479_b(IItemWolfArmor.ARMOR_UUID);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemWolfArmor)) {
            return;
        }
        ItemWolfArmor armorItem = (ItemWolfArmor)stack.func_77973_b();
        Multimap<String, AttributeModifier> map = armorItem.getAttributeModifiers(EntityEquipmentSlot.CHEST, stack);
        if (map.containsKey((Object)instance.func_111123_a().func_111108_a())) {
            map.get((Object)instance.func_111123_a().func_111108_a()).forEach(arg_0 -> ((IAttributeInstance)instance).func_111121_a(arg_0));
        }
    }

    private void addMovementStat(double deltaX, double deltaY, double deltaZ) {
        if (!this.func_184218_aH()) {
            int magnitude2d;
            if (this.func_70055_a(Material.field_151586_h)) {
                int magnitude3d = Math.round(MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)) * 100.0f);
                if (magnitude3d > 0) {
                    this.addExhaustion(0.01f * (float)magnitude3d * 0.01f);
                }
            } else if (this.func_70090_H()) {
                int magnitude2d2 = Math.round(MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 100.0f);
                if (magnitude2d2 > 0) {
                    this.addExhaustion(0.01f * (float)magnitude2d2 * 0.01f);
                }
            } else if (this.field_70122_E && (magnitude2d = Math.round(MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ)) * 100.0f)) > 0 && this.func_70051_ag()) {
                this.addExhaustion(0.1f * (float)magnitude2d * 0.01f);
            }
        }
    }

    private void inventoryInit() {
        ContainerHorseChest inventoryExisting = this.inventory;
        this.inventory = new ContainerHorseChest("inventory.wolfarmor.wolf", this.getMaxSizeInventory());
        String customWolfName = this.func_95999_t();
        if (!customWolfName.isEmpty()) {
            this.inventory.func_110133_a(customWolfName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int slotCount = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < slotCount; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    private void playEquipSound(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SoundEvent sound = null;
        if (OreDictHelper.isOre(false, "chestWood", itemStack)) {
            sound = SoundEvents.field_187665_Y;
        }
        if (sound != null) {
            this.func_184185_a(sound, 1.0f, (this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void openWolfInventory(@Nonnull EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70907_r().func_75270_a(true);
            player.openGui((Object)WolfArmorMod.getInstance(), this.func_145782_y(), this.func_130014_f_(), MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        }
    }

    private void processLegacyDataTags(@Nonnull NBTTagCompound compound) {
        NBTTagCompound armorTags;
        WolfArmorMod.getLogger().log(Level.INFO, "[NBT LOAD] Updating capable wolf to mixin wolf...");
        boolean hasChest = compound.func_74767_n("hasChest");
        this.setHasChest(hasChest);
        if (hasChest) {
            this.inventoryInit();
            this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)new ItemStack((Block)Blocks.field_150486_ae, 1));
            NBTTagList inventoryTagList = compound.func_150295_c("inventory", 10);
            for (int index = 0; index < inventoryTagList.func_74745_c(); ++index) {
                NBTTagCompound compoundTagAt = inventoryTagList.func_150305_b(index);
                byte slotIndex = compoundTagAt.func_74771_c("slot");
                if (slotIndex >= 0 && slotIndex < this.inventory.func_70302_i_()) {
                    this.inventory.func_70299_a((int)slotIndex, new ItemStack(compoundTagAt));
                    continue;
                }
                WolfArmorMod.getLogger().log(Level.WARN, String.format("[NBT LOAD] Discarded invalid slot information at index %d", slotIndex));
            }
        }
        if (!(armorTags = compound.func_74775_l("armorItem")).func_82582_d()) {
            ItemStack armorItemStack = new ItemStack(armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    private void dispatchPotionEffectMessage(PotionEffect effect, boolean removeEffect) {
        MessageBase.ClientMessageBase message = removeEffect ? new RemovePotionEffectMessage(this.func_145782_y(), effect.func_188419_a()) : new UpdatePotionEffectMessage(this.func_145782_y(), effect);
        this.connection.sendToAll((IMessage)message);
    }

    private int xpRoundAverage(float value) {
        float floor = MathHelper.func_76141_d((float)value);
        return (int)floor + (Math.random() < (double)(value - floor) ? 1 : 0);
    }

    static {
        DataHelper.HAS_CHEST = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187198_h);
        DataHelper.ARMOR_ITEM = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187196_f);
        DataHelper.CHEST_TYPE = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187196_f);
    }
}

