/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.ic2patcher.asm;

import LZMA.LzmaInputStream;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.common.patcher.ClassPatch;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.repackage.com.nothome.delta.GDiffPatcher;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinPatchManager {
    public static final boolean dumpPatched = Boolean.parseBoolean(System.getProperty("fml.dumpPatchedClasses", "false"));
    public static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("fml.debugClassPatchManager", "false"));
    public static final Logger LOG = LogManager.getLogger((String)"BinPatchManager");
    public static final BinPatchManager INSTANCE = new BinPatchManager();
    private final GDiffPatcher patcher = new GDiffPatcher();
    private ListMultimap<String, ClassPatch> patches;
    private Map<String, byte[]> patchedClasses = Maps.newHashMap();
    private File tempDir;

    private BinPatchManager() {
        if (dumpPatched) {
            this.tempDir = Files.createTempDir();
            LOG.info("Dumping patched classes to {}", (Object)this.tempDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] applyPatch(String name, String mappedName, byte[] inputData) {
        if (this.patches == null) {
            return inputData;
        }
        if (this.patchedClasses.containsKey(name)) {
            return this.patchedClasses.get(name);
        }
        List list = this.patches.get((Object)name);
        if (list.isEmpty()) {
            return inputData;
        }
        boolean ignoredError = false;
        if (DEBUG) {
            LOG.debug("Runtime patching class {} (input size {}), found {} patch{}", (Object)mappedName, (Object)(inputData == null ? 0 : inputData.length), (Object)list.size(), (Object)(list.size() != 1 ? "es" : ""));
        }
        for (ClassPatch patch : list) {
            if (!patch.targetClassName.equals(mappedName) && !patch.sourceClassName.equals(name)) {
                LOG.warn("Binary patch found {} for wrong class {}", (Object)patch.targetClassName, (Object)mappedName);
            }
            if (!(patch.existsAtTarget || inputData != null && inputData.length != 0)) {
                inputData = new byte[]{};
            } else if (!patch.existsAtTarget) {
                LOG.warn("Patcher expecting empty class data file for {}, but received non-empty", (Object)patch.targetClassName);
            } else {
                if (patch.existsAtTarget && (inputData == null || inputData.length == 0)) {
                    LOG.fatal("Patcher expecting non-empty class data file for {}, but received empty.", (Object)patch.targetClassName);
                    throw new RuntimeException(String.format("Patcher expecting non-empty class data file for %s, but received empty, your vanilla jar may be corrupt.", patch.targetClassName));
                }
                int inputChecksum = Hashing.adler32().hashBytes(inputData).asInt();
                if (patch.inputChecksum != inputChecksum) {
                    LOG.fatal("There is a binary discrepancy between the expected input class {} ({}) and the actual class. Checksum on disk is {}, in patch {}. Things are probably about to go very wrong. Did you put something into the jar file?", (Object)mappedName, (Object)name, (Object)Integer.toHexString(inputChecksum), (Object)Integer.toHexString(patch.inputChecksum));
                    if (!Boolean.parseBoolean(System.getProperty("fml.ignorePatchDiscrepancies", "false"))) {
                        LOG.fatal("The game is going to exit, because this is a critical error, and it is very improbable that the modded game will work, please obtain clean jar files.");
                        System.exit(1);
                    } else {
                        LOG.fatal("FML is going to ignore this error, note that the patch will not be applied, and there is likely to be a malfunctioning behaviour, including not running at all");
                        ignoredError = true;
                        continue;
                    }
                }
            }
            GDiffPatcher gDiffPatcher = this.patcher;
            synchronized (gDiffPatcher) {
                try {
                    inputData = this.patcher.patch(inputData, patch.patch);
                }
                catch (IOException e) {
                    LOG.error("Encountered problem runtime patching class {}", (Object)name, (Object)e);
                }
            }
        }
        if (!ignoredError) {
            LOG.info("Successfully applied runtime patches for {} (new size {})", (Object)mappedName, (Object)inputData.length);
        }
        if (dumpPatched) {
            try {
                Files.write((byte[])inputData, (File)new File(this.tempDir, mappedName));
            }
            catch (IOException e) {
                LOG.error(LOG.getMessageFactory().newMessage("Failed to write {} to {}", new Object[]{mappedName, this.tempDir.getAbsolutePath()}), (Throwable)e);
            }
        }
        this.patchedClasses.put(name, inputData);
        return inputData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(File modJar) {
        InputStream binpatchesCompressed;
        JarInputStream jis;
        Pattern binpatchMatcher;
        block34: {
            block35: {
                binpatchMatcher = Pattern.compile(String.format("binpatch/%s/.*.binpatch", "merged"));
                jis = null;
                ZipFile zip = new ZipFile(modJar);
                binpatchesCompressed = zip.getInputStream(zip.getEntry("ic2patches.pack.lzma"));
                if (binpatchesCompressed != null) break block34;
                if (FMLLaunchHandler.isDeobfuscatedEnvironment()) break block35;
                LOG.fatal("The binary patch set is missing, things are not going to work!");
            }
            IOUtils.closeQuietly(jis);
            return;
        }
        try {
            try (LzmaInputStream binpatchesDecompressed = new LzmaInputStream(binpatchesCompressed);){
                ByteArrayOutputStream jarBytes = new ByteArrayOutputStream();
                try (JarOutputStream jos = new JarOutputStream(jarBytes);){
                    Pack200.newUnpacker().unpack((InputStream)binpatchesDecompressed, jos);
                    jis = new JarInputStream(new ByteArrayInputStream(jarBytes.toByteArray()));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error occurred reading binary patches. Expect severe problems!", e);
            }
            this.patches = ArrayListMultimap.create();
            try {
                JarEntry entry;
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (binpatchMatcher.matcher(entry.getName()).matches()) {
                        ClassPatch cp = this.readPatch(entry, jis);
                        if (cp == null) continue;
                        this.patches.put((Object)cp.sourceClassName, (Object)cp);
                        continue;
                    }
                    jis.closeEntry();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)jis);
        LOG.debug("Read {} binary patches", (Object)this.patches.size());
        if (DEBUG) {
            LOG.debug("Patch list :\n\t{}", (Object)Joiner.on((String)"\t\n").join(this.patches.asMap().entrySet()));
        }
        this.patchedClasses.clear();
    }

    private ClassPatch readPatch(JarEntry patchEntry, JarInputStream jis) {
        ByteArrayDataInput input;
        if (DEBUG) {
            LOG.trace("Reading patch data from {}", (Object)patchEntry.getName());
        }
        try {
            input = ByteStreams.newDataInput((byte[])ByteStreams.toByteArray((InputStream)jis));
        }
        catch (IOException e) {
            LOG.warn(LOG.getMessageFactory().newMessage("Unable to read binpatch file {} - ignoring", new Object[]{patchEntry.getName()}), (Throwable)e);
            return null;
        }
        String name = input.readUTF();
        String sourceClassName = input.readUTF();
        String targetClassName = input.readUTF();
        boolean exists = input.readBoolean();
        int inputChecksum = 0;
        if (exists) {
            inputChecksum = input.readInt();
        }
        int patchLength = input.readInt();
        byte[] patchBytes = new byte[patchLength];
        input.readFully(patchBytes);
        return new ClassPatch(name, sourceClassName, targetClassName, exists, inputChecksum, patchBytes);
    }
}

