/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.client.gui;

import java.util.ArrayList;
import java.util.List;
import logictechcorp.libraryex.client.gui.GuiScrollableButton;
import logictechcorp.libraryex.client.gui.IGuiButtonPressed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScrollableButtonList
extends GuiListExtended {
    private final List<GuiScrollableButtonData> guiScrollableButtonData;
    private final IGuiButtonPressed guiButtonPressed;
    private final List<GuiScrollableButtonEntry> guiScrollableButtons = new ArrayList<GuiScrollableButtonEntry>();

    public GuiScrollableButtonList(Minecraft mc, int width, int height, int top, int bottom, List<GuiScrollableButtonData> guiScrollableButtonData, IGuiButtonPressed guiButtonPressed) {
        super(mc, width, height, top, bottom, 25);
        this.field_148163_i = true;
        this.guiScrollableButtonData = guiScrollableButtonData;
        this.guiButtonPressed = guiButtonPressed;
        this.populateComponents();
    }

    private void populateComponents() {
        for (int i = 0; i < this.guiScrollableButtonData.size(); i += 2) {
            GuiScrollableButtonData guiScrollableButtonDataCurrent = this.guiScrollableButtonData.get(i);
            GuiScrollableButtonData guiScrollableButtonDataNext = i < this.guiScrollableButtonData.size() - 1 ? this.guiScrollableButtonData.get(i + 1) : null;
            Gui guiCurrent = this.createButton(guiScrollableButtonDataCurrent, 0);
            Gui guiNext = this.createButton(guiScrollableButtonDataNext, 160);
            GuiScrollableButtonEntry guiScrollableButtonEntry = new GuiScrollableButtonEntry(guiCurrent, guiNext);
            this.guiScrollableButtons.add(guiScrollableButtonEntry);
        }
    }

    private Gui createButton(GuiScrollableButtonData data, int x) {
        if (data != null) {
            return new GuiScrollableButton(data.getId(), this.field_148155_a / 2 - 155 + x, 0, data.getText(), this.guiButtonPressed);
        }
        return null;
    }

    public int func_148139_c() {
        return 400;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 32;
    }

    public GuiScrollableButtonEntry getListEntry(int index) {
        return this.guiScrollableButtons.get(index);
    }

    protected int func_148127_b() {
        return this.guiScrollableButtons.size();
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiScrollableButtonEntry
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft minecraft = Minecraft.func_71410_x();
        private final Gui guiCurrent;
        private final Gui guiNext;

        private GuiScrollableButtonEntry(Gui guiCurrent, Gui guiNext) {
            this.guiCurrent = guiCurrent;
            this.guiNext = guiNext;
        }

        public void func_192634_a(int slotIndex, int x, int y, int width, int height, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.renderComponent(this.guiCurrent, y, mouseX, mouseY, false, partialTicks);
            this.renderComponent(this.guiNext, y, mouseX, mouseY, false, partialTicks);
        }

        private void renderComponent(Gui gui, int y, int mouseX, int mouseY, boolean updated, float partialTicks) {
            if (gui instanceof GuiButton) {
                GuiButton guiButton = (GuiButton)gui;
                guiButton.field_146129_i = y;
                if (!updated) {
                    guiButton.func_191745_a(this.minecraft, mouseX, mouseY, partialTicks);
                }
            }
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
            this.renderComponent(this.guiCurrent, y, 0, 0, true, partialTicks);
            this.renderComponent(this.guiNext, y, 0, 0, true, partialTicks);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            boolean pressedPrimaryButton = this.pressButton(this.guiCurrent, mouseX, mouseY);
            boolean pressedSecondaryButton = this.pressButton(this.guiNext, mouseX, mouseY);
            return pressedPrimaryButton || pressedSecondaryButton;
        }

        private boolean pressButton(Gui gui, int mouseX, int mouseY) {
            if (!(gui instanceof GuiButton)) {
                return false;
            }
            return ((GuiButton)gui).func_146116_c(this.minecraft, mouseX, mouseY);
        }

        public void func_148277_b(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            this.releaseComponent(this.guiCurrent, mouseX, mouseY);
            this.releaseComponent(this.guiNext, mouseX, mouseY);
        }

        private void releaseComponent(Gui gui, int mouseX, int mouseY) {
            if (gui instanceof GuiButton) {
                ((GuiButton)gui).func_146118_a(mouseX, mouseY);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class GuiScrollableButtonData {
        private final int id;
        private final String text;

        public GuiScrollableButtonData(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public int getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }
    }
}

