/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.libraryex.world.generation.trait;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import logictechcorp.libraryex.LibraryEx;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBasicTree;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBigMushroom;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitBoulder;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitDenseTree;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitFluid;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitPatch;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitPool;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitScatter;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitSparseTree;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitStructure;
import net.minecraft.util.ResourceLocation;

public final class BiomeTraitRegistry {
    public static final BiomeTraitRegistry INSTANCE = new BiomeTraitRegistry();
    private final Map<Class<? extends BiomeTrait>, ResourceLocation> biomeTraitNames = new HashMap<Class<? extends BiomeTrait>, ResourceLocation>();
    private final Map<ResourceLocation, BiomeTrait.Builder<?>> biomeTraitBuilders = new HashMap();

    private BiomeTraitRegistry() {
        this.registerBiomeTrait(LibraryEx.getResource("scatter"), new BiomeTraitScatter.Builder(), BiomeTraitScatter.class);
        this.registerBiomeTrait(LibraryEx.getResource("cluster"), new BiomeTraitCluster.Builder(), BiomeTraitCluster.class);
        this.registerBiomeTrait(LibraryEx.getResource("patch"), new BiomeTraitPatch.Builder(), BiomeTraitPatch.class);
        this.registerBiomeTrait(LibraryEx.getResource("boulder"), new BiomeTraitBoulder.Builder(), BiomeTraitBoulder.class);
        this.registerBiomeTrait(LibraryEx.getResource("ore"), new BiomeTraitOre.Builder(), BiomeTraitOre.class);
        this.registerBiomeTrait(LibraryEx.getResource("fluid"), new BiomeTraitFluid.Builder(), BiomeTraitFluid.class);
        this.registerBiomeTrait(LibraryEx.getResource("pool"), new BiomeTraitPool.Builder(), BiomeTraitPool.class);
        this.registerBiomeTrait(LibraryEx.getResource("basic_tree"), new BiomeTraitBasicTree.Builder(), BiomeTraitBasicTree.class);
        this.registerBiomeTrait(LibraryEx.getResource("dense_tree"), new BiomeTraitDenseTree.Builder(), BiomeTraitDenseTree.class);
        this.registerBiomeTrait(LibraryEx.getResource("sparse_tree"), new BiomeTraitSparseTree.Builder(), BiomeTraitSparseTree.class);
        this.registerBiomeTrait(LibraryEx.getResource("big_mushroom"), new BiomeTraitBigMushroom.Builder(), BiomeTraitBigMushroom.class);
        this.registerBiomeTrait(LibraryEx.getResource("structure"), new BiomeTraitStructure.Builder(), BiomeTraitStructure.class);
    }

    public void registerBiomeTrait(ResourceLocation registryName, BiomeTrait.Builder<?> biomeTraitBuilder, Class<? extends BiomeTrait> cls) {
        if (registryName == null || biomeTraitBuilder == null || cls == null) {
            return;
        }
        if (!this.biomeTraitNames.containsKey(cls)) {
            this.biomeTraitNames.put(cls, registryName);
        }
        if (!this.biomeTraitBuilders.containsKey(registryName)) {
            this.biomeTraitBuilders.put(registryName, biomeTraitBuilder);
        }
    }

    public void unregisterBiomeTrait(ResourceLocation registryName) {
        this.biomeTraitBuilders.remove(registryName);
    }

    public boolean hasBiomeTrait(ResourceLocation registryName) {
        return this.biomeTraitBuilders.containsKey(registryName);
    }

    public ResourceLocation getBiomeTraitName(Class<? extends BiomeTrait> cls) {
        return this.biomeTraitNames.get(cls);
    }

    public BiomeTrait.Builder<?> getBiomeTraitBuilder(ResourceLocation registryName) {
        return this.biomeTraitBuilders.get(registryName);
    }

    public Map<Class<? extends BiomeTrait>, ResourceLocation> getBiomeTraitNames() {
        return Collections.unmodifiableMap(this.biomeTraitNames);
    }

    public Map<ResourceLocation, BiomeTrait.Builder<?>> getBiomeTraitBuilders() {
        return Collections.unmodifiableMap(this.biomeTraitBuilders);
    }
}

