/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.charset.audio;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.api.audio.AudioAPI;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioSink;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.computronics.api.audio.AudioPacket;
import pl.asie.computronics.api.audio.AudioPacketDFPWM;
import pl.asie.computronics.integration.charset.audio.AudioDataDFPWM;
import pl.asie.computronics.integration.charset.audio.AudioDataDummy;
import pl.asie.computronics.integration.charset.audio.AudioReceiverCable;
import pl.asie.computronics.integration.charset.audio.AudioSinkSpeaker;
import pl.asie.computronics.integration.charset.audio.AudioSourceDummy;
import pl.asie.computronics.tile.TileAudioCable;
import pl.asie.computronics.tile.TileSpeaker;
import pl.asie.computronics.tile.TileSpeechBox;
import pl.asie.computronics.tile.TileTapeDrive;

public class IntegrationCharsetAudio {
    @CapabilityInject(value=IAudioSource.class)
    public static Capability<IAudioSource> SOURCE_CAPABILITY;
    @CapabilityInject(value=IAudioReceiver.class)
    public static Capability<IAudioReceiver> RECEIVER_CAPABILITY;
    private static final ResourceLocation CABLE_SINK_KEY;
    private static final ResourceLocation SPEAKER_SINK_KEY;
    private static final ResourceLocation TAPE_SOURCE_KEY;
    private static final ResourceLocation SPEECH_BOX_SOURCE_KEY;

    public void postInit() {
        AudioAPI.SINK_REGISTRY.register(AudioSinkSpeaker.class, AudioSinkSpeaker::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAttach(final AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileSpeaker && RECEIVER_CAPABILITY != null) {
            event.addCapability(SPEAKER_SINK_KEY, new ICapabilityProvider(){
                private final AudioSink sink;
                {
                    this.sink = new AudioSinkSpeaker((TileSpeaker)event.getObject());
                }

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == RECEIVER_CAPABILITY && facing != null;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == RECEIVER_CAPABILITY ? RECEIVER_CAPABILITY.cast((Object)this.sink) : null);
                }
            });
        } else if (event.getObject() instanceof TileAudioCable && RECEIVER_CAPABILITY != null) {
            event.addCapability(CABLE_SINK_KEY, new ICapabilityProvider(){
                private final TileAudioCable cable;
                private final AudioReceiverCable[] RECEIVERS;
                {
                    this.cable = (TileAudioCable)event.getObject();
                    this.RECEIVERS = new AudioReceiverCable[6];
                }

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == RECEIVER_CAPABILITY && facing != null;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    if (capability == RECEIVER_CAPABILITY && facing != null) {
                        if (this.RECEIVERS[facing.ordinal()] == null) {
                            this.RECEIVERS[facing.ordinal()] = new AudioReceiverCable(this.cable, facing);
                        }
                        return (T)RECEIVER_CAPABILITY.cast((Object)this.RECEIVERS[facing.ordinal()]);
                    }
                    return null;
                }
            });
        } else if (event.getObject() instanceof TileTapeDrive && SOURCE_CAPABILITY != null) {
            event.addCapability(TAPE_SOURCE_KEY, new ICapabilityProvider(){
                private final AudioSourceDummy source = new AudioSourceDummy();

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == SOURCE_CAPABILITY && facing != null;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == SOURCE_CAPABILITY ? SOURCE_CAPABILITY.cast((Object)this.source) : null);
                }
            });
        } else if (event.getObject() instanceof TileSpeechBox && SOURCE_CAPABILITY != null) {
            event.addCapability(SPEECH_BOX_SOURCE_KEY, new ICapabilityProvider(){
                private final AudioSourceDummy source = new AudioSourceDummy();

                public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == SOURCE_CAPABILITY && facing != null;
                }

                @Nullable
                public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
                    return (T)(capability == SOURCE_CAPABILITY ? SOURCE_CAPABILITY.cast((Object)this.source) : null);
                }
            });
        }
    }

    public static int send(IBlockAccess world, BlockPos pos, AudioPacket packet, float volume, boolean ignoreComputronicsAPICheck) {
        AudioDataDummy dataNew;
        if (packet instanceof AudioPacketDFPWM) {
            int time = ((AudioPacketDFPWM)packet).data.length * 8000 / ((AudioPacketDFPWM)packet).frequency;
            dataNew = new AudioDataDFPWM(packet, ((AudioPacketDFPWM)packet).data, time);
        } else {
            dataNew = new AudioDataDummy(packet);
        }
        pl.asie.charset.api.audio.AudioPacket packetNew = new pl.asie.charset.api.audio.AudioPacket((AudioData)dataNew, volume);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos posO = pos.func_177972_a(facing);
            TileEntity tile = world.func_175625_s(posO);
            if (tile == null || !tile.hasCapability(RECEIVER_CAPABILITY, facing.func_176734_d()) || !ignoreComputronicsAPICheck && tile instanceof pl.asie.computronics.api.audio.IAudioReceiver) continue;
            ((IAudioReceiver)tile.getCapability(RECEIVER_CAPABILITY, facing.func_176734_d())).receive(packetNew);
        }
        if (packetNew.getSinkCount() > 0) {
            packetNew.send();
            return packetNew.getSinkCount();
        }
        return 0;
    }

    public static boolean connects(@Nullable TileEntity tile, EnumFacing dir) {
        return tile != null && (tile.hasCapability(SOURCE_CAPABILITY, dir) || tile.hasCapability(RECEIVER_CAPABILITY, dir));
    }

    static {
        CABLE_SINK_KEY = new ResourceLocation("computronics:cableSink");
        SPEAKER_SINK_KEY = new ResourceLocation("computronics:speakerSink");
        TAPE_SOURCE_KEY = new ResourceLocation("computronics:tapeDriveSource");
        SPEECH_BOX_SOURCE_KEY = new ResourceLocation("computronics:speechBoxSource");
    }
}

