/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.gui.tooltip;

import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nullable;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import pl.asie.computronics.util.StringUtil;

public class ToolTips {
    private static final Splitter keyValueSplitter = Splitter.on((char)'=').trimResults();
    private static final Splitter lineSplitter = Splitter.on((String)"\n").trimResults();

    @Nullable
    public static ToolTip buildToolTip(String tipTag, String ... vars) {
        return ToolTips.buildToolTip(tipTag, 750, vars);
    }

    @Nullable
    public static ToolTip buildToolTip(String tipTag, int delay, String ... vars) {
        if (!StringUtil.canTranslate(tipTag)) {
            return null;
        }
        try {
            ToolTip ex = new ToolTip(delay);
            String text = LocalizationPlugin.translate((String)tipTag);
            for (String var : vars) {
                List pair = keyValueSplitter.splitToList((CharSequence)var);
                text = text.replace((CharSequence)pair.get(0), (CharSequence)pair.get(1));
            }
            for (String var11 : lineSplitter.split((CharSequence)text)) {
                ex.add((Object)new ToolTipLine(var11));
            }
            return ex;
        }
        catch (RuntimeException var9) {
            Game.log().throwable("Failed to parse tooltip: " + tipTag, (Throwable)var9, new Object[0]);
            throw var9;
        }
    }
}

