/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import java.util.ArrayDeque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import li.cil.oc.api.Network;
import li.cil.oc.api.component.RackBusConnectable;
import li.cil.oc.api.component.RackMountable;
import li.cil.oc.api.internal.Rack;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.util.StateAware;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.oc.driver.DriverCardBoom;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.computronics.util.boom.SelfDestruct;

public class DriverBoardBoom
extends DriverCardBoom
implements RackMountable {
    protected final Rack container;
    protected boolean needsUpdate;
    protected boolean isActive;

    public DriverBoardBoom(Rack container) {
        super((EnvironmentHost)container);
        this.container = container;
    }

    @Override
    protected void createNode() {
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("server_destruct", Visibility.Network).withConnector().create());
    }

    @Override
    public void update() {
        this.setActive(this.node.tryChangeBuffer(-Config.BOOM_BOARD_MAINTENANCE_COST));
        if (this.needsUpdate) {
            this.container.markChanged(this.container.indexOfMountable((RackMountable)this));
            this.needsUpdate = false;
        }
        if (!this.isActive) {
            this.setTime(-1);
            return;
        }
        super.update();
    }

    @Override
    protected void setTime(int time) {
        if (time != this.time) {
            super.setTime(time);
            this.needsUpdate = true;
        }
    }

    public void setActive(boolean active) {
        if (active != this.isActive) {
            this.isActive = active;
            this.needsUpdate = true;
        }
    }

    @Override
    protected void goBoom() {
        Rack cur;
        LinkedHashSet<Rack> racks = new LinkedHashSet<Rack>();
        ArrayDeque<Rack> toSearch = new ArrayDeque<Rack>();
        toSearch.add(this.container);
        racks.add(this.container);
        Vec3d origin = new Vec3d(this.container.xPosition(), this.container.yPosition(), this.container.zPosition());
        while ((cur = (Rack)toSearch.poll()) != null) {
            World world = cur.world();
            BlockPos currentPos = new BlockPos(cur.xPosition(), cur.yPosition(), cur.zPosition());
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileEntity tile;
                BlockPos pos = currentPos.func_177972_a(dir);
                Vec3d vec3d = new Vec3d((Vec3i)pos);
                if (!(origin.func_72436_e(vec3d) <= 256.0) || !world.func_175667_e(pos) || !((tile = world.func_175625_s(pos)) instanceof Rack) || !racks.add((Rack)tile)) continue;
                toSearch.add((Rack)tile);
            }
        }
        ArrayDeque<Set<Rack>> rackList = new ArrayDeque<Set<Rack>>((racks.size() + 5) / 6);
        Iterator itr = racks.iterator();
        while (itr.hasNext()) {
            HashSet<Rack> sub = new HashSet<Rack>(6);
            for (int i = 0; i < 6 && itr.hasNext(); ++i) {
                Rack rack = (Rack)itr.next();
                sub.add(rack);
            }
            rackList.add(sub);
        }
        IntegrationOpenComputers.boomBoardHandler.queue(this.container, rackList);
    }

    public NBTTagCompound getData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("t", this.time >= 0);
        tag.func_74757_a("r", this.isActive);
        return tag;
    }

    @Override
    public void onDisconnect(Node node) {
    }

    @Override
    public void onMessage(Message message) {
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74767_n("active")) {
            this.setActive(nbt.func_74767_n("active"));
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74757_a("active", this.isActive);
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("generic", "Server-cleaning service", "Hugging Creeper Industries", "SSD-Struct M4", new String[0]);
    }

    public int getConnectableCount() {
        return 0;
    }

    public RackBusConnectable getConnectableAt(int index) {
        return null;
    }

    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY) {
        return false;
    }

    public EnumSet<StateAware.State> getCurrentState() {
        return EnumSet.noneOf(StateAware.State.class);
    }

    public static class BoomHandler {
        private final Set<Pair<Rack, Queue<Set<Rack>>>> boomQueue = new HashSet<Pair<Rack, Queue<Set<Rack>>>>();

        @SubscribeEvent
        @Optional.Method(modid="opencomputers")
        public void onServerTick(TickEvent.ServerTickEvent e) {
            if (e.phase != TickEvent.Phase.START || this.boomQueue.isEmpty()) {
                return;
            }
            HashSet<Pair<Rack, Queue<Set<Rack>>>> toRemove = new HashSet<Pair<Rack, Queue<Set<Rack>>>>();
            for (Pair<Rack, Queue<Set<Rack>>> lists : this.boomQueue) {
                if ((((Rack)lists.getKey()).world().func_82737_E() + (long)lists.hashCode()) % 5L != 0L) continue;
                Set current = (Set)((Queue)lists.getValue()).poll();
                for (Rack rack : current) {
                    SelfDestruct.goBoom(rack.world(), rack.xPosition(), rack.yPosition(), rack.zPosition(), false);
                }
                if (!((Queue)lists.getValue()).isEmpty()) continue;
                toRemove.add(lists);
            }
            this.boomQueue.removeAll(toRemove);
        }

        @Optional.Method(modid="opencomputers")
        public void queue(Rack owner, Queue<Set<Rack>> rackList) {
            this.boomQueue.add((Pair<Rack, Queue<Set<Rack>>>)Pair.of((Object)owner, rackList));
        }
    }
}

