/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.util.sound;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.sound.AudioType;

public class AudioUtil {

    public static class AudioProcess {
        public final ImmutableList<State> states;
        public int delay = 0;
        public double error = 0.0;

        public AudioProcess(int channelCount) {
            ArrayList<State> states = new ArrayList<State>(channelCount);
            for (int i = 0; i < channelCount; ++i) {
                states.add(new State(i));
            }
            this.states = ImmutableList.copyOf(states);
        }

        public void load(NBTTagCompound nbt) {
            for (int i = 0; i < this.states.size(); ++i) {
                if (!nbt.func_74764_b("ch" + i)) continue;
                ((State)this.states.get(i)).load(nbt.func_74775_l("ch" + i));
            }
            if (nbt.func_74764_b("delay")) {
                this.delay = nbt.func_74762_e("delay");
            }
        }

        public void save(NBTTagCompound nbt) {
            for (int i = 0; i < this.states.size(); ++i) {
                NBTTagCompound stateNBT = new NBTTagCompound();
                nbt.func_74782_a("ch" + i, (NBTBase)stateNBT);
                ((State)this.states.get(i)).save(stateNBT);
            }
            nbt.func_74768_a("delay", this.delay);
        }
    }

    public static class State {
        public Generator generator;
        public final int channelIndex;
        public float frequencyInHz;
        public float offset;
        public Gate gate = Gate.Closed;
        public FrequencyModulation freqMod;
        public AmplitudeModulation ampMod;
        public ADSR envelope;
        public float volume = 1.0f;
        public boolean isFreqMod;
        public boolean isAmpMod;

        public State(int channelIndex) {
            this.generator = new Wave();
            this.channelIndex = channelIndex;
        }

        public void load(NBTTagCompound nbt) {
            if (nbt.func_74764_b("wavehz")) {
                this.frequencyInHz = nbt.func_74760_g("wavehz");
            }
            if (nbt.func_74764_b("offset")) {
                this.offset = nbt.func_74760_g("offset");
            }
            if (nbt.func_74764_b("type")) {
                this.generator = new Wave(AudioType.fromIndex(nbt.func_74762_e("type")));
            }
            if (nbt.func_74764_b("noise")) {
                this.generator = Noise.load(nbt.func_74775_l("noise"));
            }
            if (nbt.func_74764_b("gate")) {
                this.gate = Gate.fromIndex(nbt.func_74762_e("gate"));
            }
            if (nbt.func_74764_b("fmodi") && nbt.func_74764_b("findex")) {
                this.freqMod = new FrequencyModulation(nbt.func_74762_e("fmodi"), nbt.func_74760_g("findex"));
            }
            if (nbt.func_74764_b("amodi")) {
                this.ampMod = new AmplitudeModulation(nbt.func_74762_e("amodi"));
            }
            if (nbt.func_74764_b("a")) {
                this.envelope = new ADSR(nbt.func_74762_e("a"), nbt.func_74762_e("d"), nbt.func_74760_g("s"), nbt.func_74762_e("r"));
                this.envelope.phase = ADSR.Phase.fromIndex(nbt.func_74762_e("p"));
                this.envelope.progress = nbt.func_74769_h("o");
            }
            if (nbt.func_74764_b("vol")) {
                this.volume = nbt.func_74760_g("vol");
            }
            if (nbt.func_74764_b("isfmod")) {
                this.isFreqMod = nbt.func_74767_n("isfmod");
            }
            if (nbt.func_74764_b("isamod")) {
                this.isAmpMod = nbt.func_74767_n("isamod");
            }
        }

        public void save(NBTTagCompound nbt) {
            nbt.func_74776_a("wavehz", this.frequencyInHz);
            nbt.func_74776_a("offset", this.offset);
            if (this.generator instanceof Wave && ((Wave)this.generator).type != null) {
                nbt.func_74768_a("type", ((Wave)this.generator).type.ordinal());
            }
            if (this.generator instanceof Noise) {
                NBTTagCompound data = new NBTTagCompound();
                ((Noise)this.generator).save(data);
                nbt.func_74782_a("noise", (NBTBase)data);
            }
            nbt.func_74768_a("gate", this.gate.ordinal());
            if (this.freqMod != null) {
                nbt.func_74768_a("fmodi", this.freqMod.modulatorIndex);
                nbt.func_74776_a("findex", this.freqMod.index);
            }
            if (this.ampMod != null) {
                nbt.func_74768_a("amodi", this.ampMod.modulatorIndex);
            }
            if (this.envelope != null) {
                nbt.func_74768_a("a", this.envelope.attackDuration);
                nbt.func_74768_a("d", this.envelope.decayDuration);
                nbt.func_74776_a("s", this.envelope.attenuation);
                nbt.func_74768_a("r", this.envelope.releaseDuration);
                nbt.func_74768_a("p", this.envelope.phase.ordinal());
                nbt.func_74780_a("o", this.envelope.progress);
            }
            nbt.func_74776_a("vol", this.volume);
            nbt.func_74757_a("isfmod", this.isFreqMod);
            nbt.func_74757_a("isamod", this.isAmpMod);
        }
    }

    public static class LFSR
    extends Noise {
        private int value;
        private final int mask;

        public LFSR(int value, int mask) {
            this.value = value;
            this.mask = mask;
        }

        @Override
        protected double generate(State state) {
            if ((this.value & 1) != 0) {
                this.value = this.value >>> 1 ^ this.mask;
                return 1.0;
            }
            this.value >>>= 1;
            return -1.0;
        }

        @Override
        protected void save(NBTTagCompound nbt) {
            nbt.func_74774_a("t", (byte)1);
            nbt.func_74780_a("o", this.noiseOutput);
            nbt.func_74768_a("v", this.value);
            nbt.func_74768_a("m", this.mask);
        }
    }

    public static class WhiteNoise
    extends Noise {
        @Override
        protected double generate(State state) {
            return Math.random() * 2.0 - 1.0;
        }

        @Override
        protected void save(NBTTagCompound nbt) {
            nbt.func_74774_a("t", (byte)0);
            nbt.func_74780_a("o", this.noiseOutput);
        }
    }

    public static abstract class Noise
    extends Generator {
        public double noiseOutput;

        public void updateModifier(State state) {
            this.noiseOutput = this.generate(state);
        }

        protected abstract double generate(State var1);

        public static Noise load(NBTTagCompound nbt) {
            Noise noise;
            switch (nbt.func_74771_c("t")) {
                case 1: {
                    noise = new LFSR(nbt.func_74762_e("v"), nbt.func_74762_e("m"));
                    break;
                }
                default: {
                    noise = new WhiteNoise();
                }
            }
            noise.noiseOutput = nbt.func_74769_h("o");
            return noise;
        }

        protected abstract void save(NBTTagCompound var1);
    }

    public static class Wave
    extends Generator {
        public AudioType type = AudioType.Square;

        public Wave() {
        }

        public Wave(AudioType type) {
            this.type = type;
        }
    }

    public static abstract class Generator {
    }

    public static class ADSR {
        public int attackDuration;
        public int decayDuration;
        public float attenuation;
        public int releaseDuration;
        public Phase phase = Phase.Attack;
        public double progress;
        private final Phase initialPhase;
        private final double initialProgress;
        private double attackSpeed;
        private double decaySpeed;
        private double releaseSpeed;

        public ADSR(int attackDuration, int decayDuration, float attenuation, int releaseDuration) {
            this.attackDuration = Math.max(attackDuration, 0);
            this.decayDuration = Math.max(decayDuration, 0);
            this.attenuation = Math.min(Math.max(attenuation, 0.0f), 1.0f);
            this.releaseDuration = Math.max(releaseDuration, 0);
            this.attackSpeed = 1000.0 / (double)(this.attackDuration * Config.SOUND_SAMPLE_RATE);
            if (this.attackDuration == 0) {
                if (this.decayDuration == 0) {
                    this.initialPhase = this.phase = Phase.Sustain;
                    this.initialProgress = this.progress = (double)attenuation;
                } else {
                    this.initialPhase = this.phase = Phase.Decay;
                    this.progress = 1.0;
                    this.initialProgress = 1.0;
                }
            } else {
                this.initialPhase = Phase.Attack;
                this.progress = 0.0;
                this.initialProgress = 0.0;
            }
            this.decaySpeed = this.decayDuration == 0 ? Double.POSITIVE_INFINITY : ((double)this.attenuation - 1.0) * 1000.0 / (double)(this.decayDuration * Config.SOUND_SAMPLE_RATE);
            this.releaseSpeed = this.releaseDuration == 0 ? Double.NEGATIVE_INFINITY : (double)(-this.attenuation) * 1000.0 / (double)(this.releaseDuration * Config.SOUND_SAMPLE_RATE);
        }

        public double getModifiedValue(State state, double value) {
            if (this.phase == null) {
                return 0.0;
            }
            if (state.gate == Gate.Closed && this.phase != Phase.Release) {
                this.phase = Phase.Release;
            }
            switch (this.phase) {
                case Attack: {
                    double d;
                    this.progress += this.attackSpeed;
                    if (!(d >= 1.0)) break;
                    this.progress = 1.0;
                    this.nextPhase();
                    break;
                }
                case Decay: {
                    double d;
                    this.progress += this.decaySpeed;
                    if (!(d <= (double)this.attenuation)) break;
                    this.progress = this.attenuation;
                    this.nextPhase();
                    break;
                }
                case Release: {
                    double d;
                    this.progress += this.releaseSpeed;
                    if (!(d <= 0.0)) break;
                    this.phase = null;
                    this.progress = 0.0;
                }
            }
            return value *= this.progress;
        }

        private void nextPhase() {
            this.phase = this.phase.next();
        }

        public void reset() {
            this.phase = this.initialPhase;
            this.progress = this.initialProgress;
        }

        private static enum Phase {
            Attack,
            Decay,
            Sustain,
            Release;

            public static final Phase[] VALUES;

            @Nullable
            public Phase next() {
                int ordinal = this.ordinal();
                return ordinal < VALUES.length ? VALUES[ordinal + 1] : null;
            }

            public static Phase fromIndex(int index) {
                return index >= 0 && index < VALUES.length ? VALUES[index] : Attack;
            }

            static {
                VALUES = Phase.values();
            }
        }
    }

    public static class AmplitudeModulation
    extends Modulation {
        public final int modulatorIndex;

        public AmplitudeModulation(int modulatorIndex) {
            this.modulatorIndex = modulatorIndex;
        }

        @Override
        public double getModifiedValue(AudioProcess process, State state, double value) {
            State mstate = (State)process.states.get(this.modulatorIndex);
            return value * (1.0 + mstate.gate.getValue(process, mstate, true));
        }
    }

    public static class FrequencyModulation
    extends Modulation {
        public final int modulatorIndex;
        public final float index;

        public FrequencyModulation(int modulatorIndex, float index) {
            this.modulatorIndex = modulatorIndex;
            this.index = index;
        }

        @Override
        public double getModifiedValue(AudioProcess process, State state, double value) {
            State mstate = (State)process.states.get(this.modulatorIndex);
            double deviation = mstate.gate.getValue(process, mstate, true) * (double)this.index;
            state.offset = (float)((double)state.offset + ((double)state.frequencyInHz + deviation) / (double)Config.SOUND_SAMPLE_RATE);
            return value;
        }
    }

    public static abstract class Modulation {
        public abstract double getModifiedValue(AudioProcess var1, State var2, double var3);
    }

    public static enum Gate {
        Open{

            @Override
            public double getValue(AudioProcess process, State state, boolean isModulating) {
                double value;
                if (!isModulating && (state.isAmpMod || state.isFreqMod)) {
                    return 0.0;
                }
                double d = state.generator instanceof Noise ? ((Noise)state.generator).noiseOutput : (value = state.generator instanceof Wave ? ((Wave)state.generator).type.generate(state.offset) : 0.0);
                if (state.freqMod != null && !state.isFreqMod && !state.isAmpMod) {
                    value = state.freqMod.getModifiedValue(process, state, value);
                } else {
                    state.offset += state.frequencyInHz / (float)Config.SOUND_SAMPLE_RATE;
                }
                if (state.offset > 1.0f) {
                    state.offset %= 1.0f;
                    if (state.generator instanceof Noise) {
                        ((Noise)state.generator).updateModifier(state);
                    }
                }
                if (state.ampMod != null && !state.isAmpMod && !state.isFreqMod) {
                    value = state.ampMod.getModifiedValue(process, state, value);
                }
                if (state.envelope != null) {
                    value = state.envelope.getModifiedValue(state, value);
                }
                return value * (double)state.volume;
            }
        }
        ,
        Closed{

            @Override
            public double getValue(AudioProcess process, State state, boolean isModulating) {
                if (state.envelope != null && state.envelope.phase != null) {
                    return Open.getValue(process, state, isModulating);
                }
                return 0.0;
            }
        };

        public static final Gate[] VALUES;

        public abstract double getValue(AudioProcess var1, State var2, boolean var3);

        public double getValue(AudioProcess process, State state) {
            return this.getValue(process, state, false);
        }

        public static Gate fromIndex(int index) {
            return index >= 0 && index < VALUES.length ? VALUES[index] : Closed;
        }

        static {
            VALUES = Gate.values();
        }
    }
}

