/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.gui.container;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import pl.asie.lib.AsieLibMod;

public abstract class ContainerInventory
extends Container {
    private final IInventory inventory;
    private final int containerSize;

    public ContainerInventory(@Nullable IInventory inventory) {
        this.inventory = inventory;
        this.containerSize = inventory != null ? inventory.func_70302_i_() : 0;
    }

    public int getSize() {
        return this.containerSize;
    }

    public IInventory getInventoryObject() {
        return this.inventory;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        if (this.inventory == null) {
            return ItemStack.field_190927_a;
        }
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            this.tryTransferStackInSlot(slotObject, slotObject.field_75224_c == this.inventory);
            if (!AsieLibMod.proxy.isClient()) {
                this.func_75142_b();
            }
        }
        return ItemStack.field_190927_a;
    }

    protected void tryTransferStackInSlot(Slot from, boolean intoPlayerInventory) {
        Slot intoSlot;
        int i;
        int end;
        ItemStack fromStack = from.func_75211_c();
        boolean somethingChanged = false;
        int step = intoPlayerInventory ? -1 : 1;
        int begin = intoPlayerInventory ? this.field_75151_b.size() - 1 : 0;
        int n = end = intoPlayerInventory ? 0 : this.field_75151_b.size() - 1;
        if (fromStack.func_77976_d() > 1) {
            i = begin;
            while (i * step <= end) {
                if (i >= 0 && i < this.field_75151_b.size() && from.func_75216_d() && from.func_75211_c().func_190916_E() > 0) {
                    intoSlot = (Slot)this.field_75151_b.get(i);
                    if (intoSlot.field_75224_c != from.field_75224_c && intoSlot.func_75216_d()) {
                        int itemsMoved;
                        boolean slotHasCapacity;
                        ItemStack intoStack = intoSlot.func_75211_c();
                        boolean itemsAreEqual = fromStack.func_77969_a(intoStack) && ItemStack.func_77970_a((ItemStack)fromStack, (ItemStack)intoStack);
                        int maxStackSize = Math.min(fromStack.func_77976_d(), intoSlot.func_75219_a());
                        boolean bl = slotHasCapacity = intoStack.func_190916_E() < maxStackSize;
                        if (itemsAreEqual && slotHasCapacity && (itemsMoved = Math.min(maxStackSize - intoStack.func_190916_E(), fromStack.func_190916_E())) > 0) {
                            intoStack.func_190917_f(from.func_75209_a(itemsMoved).func_190916_E());
                            intoSlot.func_75218_e();
                            somethingChanged = true;
                        }
                    }
                }
                i += step;
            }
        }
        i = begin;
        while (i * step <= end) {
            if (i >= 0 && i < this.field_75151_b.size() && from.func_75216_d() && from.func_75211_c().func_190916_E() > 0) {
                intoSlot = (Slot)this.field_75151_b.get(i);
                if (intoSlot.field_75224_c != from.field_75224_c && !intoSlot.func_75216_d() && intoSlot.func_75214_a(fromStack)) {
                    int maxStackSize = Math.min(fromStack.func_77976_d(), intoSlot.func_75219_a());
                    int itemsMoved = Math.min(maxStackSize, fromStack.func_190916_E());
                    intoSlot.func_75215_d(from.func_75209_a(itemsMoved));
                    somethingChanged = true;
                }
            }
            i += step;
        }
        if (somethingChanged) {
            from.func_75218_e();
        }
    }

    public void bindPlayerInventory(InventoryPlayer inventoryPlayer, int startX, int startY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, startX + j * 18, startY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, startX + i * 18, startY + 58));
        }
    }
}

