/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.persistent_bits;

import com.oitsjustjose.persistent_bits.Config;
import com.oitsjustjose.persistent_bits.block.BlockChunkLoader;
import com.oitsjustjose.persistent_bits.chunkloading.ChunkLoadingCallback;
import com.oitsjustjose.persistent_bits.chunkloading.ChunkLoadingDatabase;
import com.oitsjustjose.persistent_bits.chunkloading.DimCoordinate;
import com.oitsjustjose.persistent_bits.proxy.CommonProxy;
import com.oitsjustjose.persistent_bits.tileentity.TileChunkLoader;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="persistentbits", name="Persistent Bits", version="1.0.6a", acceptedMinecraftVersions="1.11", dependencies="after:rftoolsdim")
public class PersistentBits {
    @Mod.Instance(value="persistentbits")
    public static PersistentBits INSTANCE;
    @SidedProxy(clientSide="com.oitsjustjose.persistent_bits.proxy.ClientProxy", serverSide="com.oitsjustjose.persistent_bits.proxy.CommonProxy", modId="persistentbits")
    public static CommonProxy proxy;
    public static Logger LOGGER;
    public static Config config;
    public static Block chunkLoader;
    public static ChunkLoadingDatabase database;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Config(event.getSuggestedConfigurationFile());
        chunkLoader = new BlockChunkLoader();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)INSTANCE, (ForgeChunkManager.LoadingCallback)new ChunkLoadingCallback());
    }

    @Mod.EventHandler
    public void postInit(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            proxy.register(Item.func_150898_a((Block)chunkLoader));
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        database = new ChunkLoadingDatabase();
        database.deserialize();
        for (DimCoordinate coord : database.getCoordinates()) {
            TileChunkLoader chunkLoader;
            WorldServer world = DimensionManager.getWorld((int)coord.getDimensionID());
            if (world == null || world.field_72995_K || (chunkLoader = (TileChunkLoader)world.func_175625_s(coord.getPos())) == null) continue;
            chunkLoader.func_145834_a((World)world);
            chunkLoader.func_145829_t();
            if (!PersistentBits.config.enableNotification) continue;
            LOGGER.info("The Chunk Loader at " + coord + " has been automatically loaded!");
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)"Persistent Bits");
    }
}

