/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.persistent_bits.block;

import com.mojang.authlib.GameProfile;
import com.oitsjustjose.persistent_bits.PersistentBits;
import com.oitsjustjose.persistent_bits.chunkloading.DimCoordinate;
import com.oitsjustjose.persistent_bits.security.Security;
import com.oitsjustjose.persistent_bits.tileentity.TileChunkLoader;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockChunkLoader
extends BlockContainer {
    public ChatUtil chatUtil;

    public BlockChunkLoader() {
        super(Material.field_151576_e);
        this.func_149711_c(10.0f);
        this.func_149752_b(1000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149663_c("persistentbits.chunk_loader");
        this.setRegistryName(new ResourceLocation("persistentbits", "chunk_loader"));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register(new ItemBlock((Block)this).setRegistryName("persistentbits", "chunk_loader"));
        GameRegistry.registerTileEntity(TileChunkLoader.class, (String)"persistentbitschunk_loader");
        if (PersistentBits.config.enableSecurity) {
            MinecraftForge.EVENT_BUS.register((Object)new Security());
        }
        this.chatUtil = new ChatUtil();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileChunkLoader();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        TileChunkLoader chunkTile = (TileChunkLoader)world.func_175625_s(pos);
        if (chunkTile != null) {
            this.toggleVisualization(world, pos, player, chunkTile);
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer && !world.field_72995_K) {
            EntityPlayer player = (EntityPlayer)placer;
            GameProfile ownerProfile = new GameProfile(player.func_110124_au(), player.func_70005_c_());
            TileChunkLoader chunkTile = (TileChunkLoader)world.func_175625_s(pos);
            if (chunkTile != null) {
                chunkTile.setOwner(ownerProfile);
            }
            if (PersistentBits.config.enableNotification) {
                PersistentBits.LOGGER.info("Player " + player.func_70005_c_() + " has placed a Chunk Loader at coordinates: x = " + pos.func_177958_n() + ", y = " + pos.func_177956_o() + ", z = " + pos.func_177952_p() + " in Dimension " + world.field_73011_w.getDimension() + ".");
            }
            PersistentBits.database.addChunkCoord(new DimCoordinate(pos, world.field_73011_w.getDimension()));
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            TileChunkLoader chunkTile = (TileChunkLoader)world.func_175625_s(pos);
            if (chunkTile != null) {
                chunkTile.stopChunkLoading();
            }
            if (PersistentBits.config.enableNotification) {
                PersistentBits.LOGGER.info("Chunk Loader at coordinates: x = " + pos.func_177958_n() + ", y = " + pos.func_177956_o() + ", z = " + pos.func_177952_p() + " in Dimension " + world.field_73011_w.getDimension() + " has been destroyed.");
            }
            try {
                PersistentBits.database.removeChunkCoord(new DimCoordinate(pos, world.field_73011_w.getDimension()));
            }
            catch (ConcurrentModificationException e) {
                PersistentBits.LOGGER.info("Concurrent Modification Exception caught!");
                super.func_180663_b(world, pos, state);
            }
        }
    }

    public void toggleVisualization(World world, BlockPos pos, @Nullable EntityPlayer player, TileChunkLoader chunkTile) {
        block11: {
            if (!world.field_72995_K) break block11;
            LinkedList<BlockPos> chunkCenters = new LinkedList<BlockPos>();
            List<ChunkPos> area = chunkTile.getLoadArea();
            IBlockState marker = this.parseMarker();
            for (ChunkPos c : area) {
                chunkCenters.add(new BlockPos((c.field_77276_a << 4) + 8, pos.func_177956_o(), (c.field_77275_b << 4) + 8));
            }
            if (chunkTile.isShowingChunks()) {
                chunkTile.setChunksHidden();
                if (player != null) {
                    this.chatUtil.sendNoSpamMessages(new ITextComponent[]{new TextComponentString("Loaded Chunks hidden").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE))});
                }
                for (BlockPos p : chunkCenters) {
                    int i = 0;
                    while (p.func_177981_b(i).func_177956_o() < p.func_177956_o() + PersistentBits.config.maxHeightIndicator) {
                        if (world.func_180495_p(p.func_177981_b(i)) == marker) {
                            world.func_175698_g(p.func_177981_b(i));
                        }
                        ++i;
                    }
                }
            } else {
                chunkTile.setChunksShown();
                if (player != null) {
                    this.chatUtil.sendNoSpamMessages(new ITextComponent[]{new TextComponentString("Loaded Chunks shown").func_150255_a(new Style().func_150238_a(TextFormatting.AQUA))});
                }
                for (BlockPos p : chunkCenters) {
                    int i = 0;
                    while (p.func_177981_b(i).func_177956_o() < p.func_177956_o() + PersistentBits.config.maxHeightIndicator) {
                        if (world.func_175623_d(p.func_177981_b(i))) {
                            world.func_175656_a(p.func_177981_b(i), marker);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public IBlockState parseMarker() {
        ResourceLocation loc;
        Block block;
        String name = PersistentBits.config.chunkIndicator;
        String[] parts = name.split(":");
        if ((parts.length == 2 || parts.length == 3) && (block = (Block)Block.field_149771_c.func_82594_a((Object)(loc = new ResourceLocation(parts[0], parts[1])))) != null) {
            return parts.length == 2 ? block.func_176223_P() : block.func_176203_a(Integer.parseInt(parts[2]));
        }
        PersistentBits.LOGGER.info("There was an issue parsing your marker block option. Please check your config's formatting.");
        return Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)EnumDyeColor.RED);
    }

    public class ChatUtil {
        private int lastAdded;

        private void sendNoSpamMessages(ITextComponent ... messages) {
            int i;
            GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
            for (i = 687981653 + messages.length - 1; i <= this.lastAdded; ++i) {
                chat.func_146242_c(i);
            }
            for (i = 0; i < messages.length; ++i) {
                chat.func_146234_a(messages[i], 687981653 + i);
            }
            this.lastAdded = 687981653 + messages.length - 1;
        }
    }
}

