/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.persistent_bits.chunkloading;

import com.oitsjustjose.persistent_bits.PersistentBits;
import com.oitsjustjose.persistent_bits.chunkloading.DimCoordinate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import net.minecraftforge.common.DimensionManager;

public class ChunkLoadingDatabase {
    private HashSet<DimCoordinate> chunkLoaderCoords = new HashSet();
    File fileLocation = new File(DimensionManager.getCurrentSaveRootDirectory(), "PersistentBits.dat");

    public void addChunkCoord(DimCoordinate newCoord) {
        this.chunkLoaderCoords.add(newCoord);
        this.serialize();
    }

    public void removeChunkCoord(DimCoordinate coordToRemove) {
        for (DimCoordinate d : this.chunkLoaderCoords) {
            if (!d.equals(coordToRemove)) continue;
            this.chunkLoaderCoords.remove(d);
            break;
        }
        this.serialize();
    }

    public HashSet<DimCoordinate> getCoordinates() {
        return this.chunkLoaderCoords;
    }

    public void serialize() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.fileLocation);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.chunkLoaderCoords);
            out.close();
            fileOut.close();
        }
        catch (IOException i) {
            PersistentBits.LOGGER.error("There was an error saving PersistentBits.dat");
            return;
        }
    }

    public void deserialize() {
        try {
            if (this.fileLocation.exists()) {
                FileInputStream fileIn = new FileInputStream(this.fileLocation);
                ObjectInputStream in = new ObjectInputStream(fileIn);
                this.chunkLoaderCoords = (HashSet)in.readObject();
                in.close();
                fileIn.close();
            }
        }
        catch (IOException i) {
            PersistentBits.LOGGER.error("There was an error loading PersistentBits.dat");
            return;
        }
        catch (ClassNotFoundException c) {
            PersistentBits.LOGGER.error("There was an error in the code for deserialization. Please contact oitsjustjose on GitHub with a log");
            PersistentBits.LOGGER.error(c.getMessage());
            return;
        }
    }
}

