/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.persistent_bits.tileentity;

import com.mojang.authlib.GameProfile;
import com.oitsjustjose.persistent_bits.PersistentBits;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileChunkLoader
extends TileEntity {
    private ForgeChunkManager.Ticket chunkTicket;
    private GameProfile owner;
    private boolean showingChunks;

    public boolean isShowingChunks() {
        return this.showingChunks;
    }

    public void setChunksShown() {
        this.showingChunks = true;
    }

    public void setChunksHidden() {
        this.showingChunks = false;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile profile) {
        this.owner = profile;
    }

    public List<ChunkPos> getLoadArea() {
        LinkedList<ChunkPos> loadArea = new LinkedList<ChunkPos>();
        int radMax = PersistentBits.config.radius;
        int radMin = 0 - radMax;
        int cx = this.field_174879_c.func_177958_n() >> 4;
        int cz = this.field_174879_c.func_177952_p() >> 4;
        for (int xMod = radMin; xMod <= radMax; ++xMod) {
            for (int zMod = radMin; zMod <= radMax; ++zMod) {
                int chunkXNew = cx + xMod;
                int chunkZNew = cz + zMod;
                loadArea.add(new ChunkPos(chunkXNew, chunkZNew));
            }
        }
        return loadArea;
    }

    public void func_145829_t() {
        ForgeChunkManager.Ticket ticket;
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && this.chunkTicket == null && (ticket = ForgeChunkManager.requestTicket((Object)PersistentBits.INSTANCE, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.forceChunkLoading(ticket);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.stopChunkLoading();
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.stopChunkLoading();
        this.chunkTicket = ticket;
        if (ticket != null) {
            ticket.getModData().func_74768_a("x", this.field_174879_c.func_177958_n());
            ticket.getModData().func_74768_a("y", this.field_174879_c.func_177956_o());
            ticket.getModData().func_74768_a("z", this.field_174879_c.func_177952_p());
            for (ChunkPos chunk : this.getLoadArea()) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
        }
    }

    public void stopChunkLoading() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        String owner = compound.func_74779_i("ownerName");
        UUID id = compound.func_186857_a("uuid");
        this.owner = new GameProfile(id, owner);
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        if (this.owner != null) {
            compound.func_74778_a("ownerName", this.owner.getName());
            compound.func_186854_a("uuid", this.owner.getId());
        }
        return super.func_189515_b(compound);
    }
}

