/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.impelon.disenchanter.DisenchanterConfig;
import de.impelon.disenchanter.item.ItemExperienceJar;
import de.impelon.disenchanter.proxy.CommonProxy;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;

public class ExperienceJarUpgrade {
    public final ModeChange overloadChange;
    public final CapacityChange capacityChange;
    public static final ExperienceJarUpgrade RESET_UPGRADE = new ExperienceJarUpgrade(ModeChange.RESET, CapacityChange.RESET);

    public static ExperienceJarUpgrade parseRecipe(JsonObject json) {
        ExperienceJarUpgrade upgrade;
        if (json.get("upgrade").isJsonObject()) {
            upgrade = ExperienceJarUpgrade.parse(JsonUtils.func_152754_s((JsonObject)json, (String)"upgrade"));
        } else if (JsonUtils.func_151200_h((JsonObject)json, (String)"upgrade").equalsIgnoreCase("reset_all")) {
            upgrade = RESET_UPGRADE;
        } else {
            throw new JsonSyntaxException("Invalid upgrade specification.");
        }
        return upgrade;
    }

    public static ExperienceJarUpgrade parse(JsonObject json) {
        String capacity;
        ModeChange overloadChange = ModeChange.UNCHANGED;
        CapacityChange capacityChange = CapacityChange.UNCHANGED;
        String overload = JsonUtils.func_151219_a((JsonObject)json, (String)"overload", null);
        if (overload != null) {
            overloadChange = ModeChange.valueOf(overload.toUpperCase());
        }
        if ((capacity = JsonUtils.func_151219_a((JsonObject)json, (String)"capacity", null)) != null) {
            capacityChange = CapacityChange.valueOf(capacity.toUpperCase());
        }
        return new ExperienceJarUpgrade(overloadChange, capacityChange);
    }

    public ExperienceJarUpgrade(ModeChange overloadChange, CapacityChange capacityChange) {
        this.overloadChange = overloadChange;
        this.capacityChange = capacityChange;
    }

    public ItemStack apply(ItemStack stack) {
        if (!stack.func_77973_b().equals((Object)CommonProxy.itemExperienceJar)) {
            return ItemStack.field_190927_a;
        }
        ItemExperienceJar.ensureValidTag(stack);
        switch (this.overloadChange) {
            case RESET: 
            case DISABLE: {
                ItemExperienceJar.setOverload(stack, false);
                break;
            }
            case ENABLE: {
                ItemExperienceJar.setOverload(stack, true);
                break;
            }
        }
        int changeMultiplier = 1;
        switch (this.capacityChange) {
            case RESET: {
                ItemExperienceJar.resetExperienceCapacity(stack);
                break;
            }
            case DECREASE: {
                changeMultiplier = -1;
            }
            case INCREASE: {
                int currentCapacity = ItemExperienceJar.getExperienceCapacity(stack);
                int capacityChange = DisenchanterConfig.experienceJar.jarUpgradeCapacityChange * changeMultiplier;
                ItemExperienceJar.setExperienceCapacity(stack, MathHelper.func_76125_a((int)(currentCapacity + capacityChange), (int)0, (int)DisenchanterConfig.experienceJar.jarUpgradeMaxCapacity));
                break;
            }
        }
        ItemExperienceJar.ensureValidTag(stack);
        return stack;
    }

    public static enum ModeChange {
        ENABLE,
        DISABLE,
        UNCHANGED,
        RESET;

    }

    public static enum CapacityChange {
        INCREASE,
        DECREASE,
        UNCHANGED,
        RESET;

    }
}

