/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.gui;

import de.impelon.disenchanter.DisenchanterConfig;
import de.impelon.disenchanter.DisenchantingProperties;
import de.impelon.disenchanter.inventory.ContainerDisenchantmentBase;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDisenchantment
extends GuiContainer {
    private static final ResourceLocation guiResource = new ResourceLocation("disenchanter", "textures/gui/container/disenchanting_table.png");
    private String tableName;
    private String inventoryName;
    private List<String> descriptions;

    public GuiDisenchantment(InventoryPlayer playerInventory, World world, BlockPos position, String tableName) {
        super((Container)ContainerDisenchantmentBase.create(playerInventory, world, position));
        this.tableName = tableName;
        this.inventoryName = playerInventory.func_145748_c_().func_150260_c();
        this.descriptions = DisenchantingProperties.getPropertiesFromStateAt(world, position).getTableVariantDescriptions();
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(x, y, partialTicks);
        this.func_191948_b(x, y);
    }

    protected void func_146979_b(int x, int y) {
        if (this.tableName != null) {
            this.field_146289_q.func_78276_b(this.tableName, 8, 5, 0x404040);
        }
        if (DisenchanterConfig.visual.showUpgradesInGUI) {
            float offset = 0.0f;
            for (String description : this.descriptions) {
                this.drawString(description, this.field_146999_f - 8, 5.0f + offset, DisenchanterConfig.visual.descriptionInGUIColor, false, TextAlignment.RIGHT_ALIGNED);
                offset += (float)(this.field_146289_q.field_78288_b + 1);
            }
        }
        this.field_146289_q.func_78276_b(this.inventoryName, 8, this.field_147000_g - 94, 0x404040);
    }

    protected void func_146976_a(float f, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiResource);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected int drawString(String text, float x, float y, int color, boolean dropShadow, TextAlignment alignment) {
        float offset = 0.0f;
        switch (alignment) {
            case CENTERED: {
                offset = this.field_146289_q.func_78256_a(text) / 2;
            }
            case RIGHT_ALIGNED: {
                offset = this.field_146289_q.func_78256_a(text);
            }
        }
        return this.field_146289_q.func_175065_a(text, x - offset, y, color, dropShadow);
    }

    public static enum TextAlignment {
        CENTERED,
        LEFT_ALIGNED,
        RIGHT_ALIGNED;

    }
}

