/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.inventory;

import de.impelon.disenchanter.inventory.ContainerDisenchantmentAutomatic;
import de.impelon.disenchanter.inventory.ContainerDisenchantmentManual;
import de.impelon.disenchanter.inventory.IDisenchantmentItemHandler;
import de.impelon.disenchanter.inventory.InventoryUtils;
import de.impelon.disenchanter.proxy.CommonProxy;
import de.impelon.disenchanter.tileentity.TileEntityDisenchantmentTableAutomatic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class ContainerDisenchantmentBase
extends Container {
    protected static final int SOURCE_SLOT = 0;
    protected static final int RECEIVER_SLOT = 1;
    protected static final int OUTPUT_SLOT = 2;
    protected static final int FIRST_NON_TABLE_SLOT = 3;
    protected World world;
    protected BlockPos position;

    public static ContainerDisenchantmentBase create(InventoryPlayer playerInventory, World world, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof TileEntityDisenchantmentTableAutomatic) {
            return new ContainerDisenchantmentAutomatic(playerInventory, world, position);
        }
        return new ContainerDisenchantmentManual(playerInventory, world, position);
    }

    public ContainerDisenchantmentBase(InventoryPlayer playerInventory, World world, BlockPos position) {
        this.world = world;
        this.position = position;
        this.addTableSlots();
        this.addPlayerSlots(playerInventory);
    }

    protected abstract IDisenchantmentItemHandler getTableInventory();

    protected void addTableSlots() {
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.getTableInventory(), 0, 26, 35));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.getTableInventory(), 1, 75, 35));
        this.func_75146_a((Slot)new SlotItemHandler(this.getTableInventory(), 2, 133, 35){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }
        });
    }

    protected void addPlayerSlots(InventoryPlayer playerInventory) {
        int tmp;
        for (tmp = 0; tmp < 3; ++tmp) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + tmp * 9 + 9, 8 + col * 18, 84 + tmp * 18));
            }
        }
        for (tmp = 0; tmp < 9; ++tmp) {
            this.func_75146_a(new Slot((IInventory)playerInventory, tmp, 8 + tmp * 18, 142));
        }
    }

    public boolean func_75145_c(EntityPlayer p) {
        return this.world.func_180495_p(this.position).func_177230_c().equals((Object)CommonProxy.disenchantmentTable) && p.func_174818_b(this.position.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public ItemStack func_82846_b(EntityPlayer p, int slotID) {
        ItemStack itemstackPrev = ItemStack.field_190927_a;
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotID);
        if (slot != null && slot.func_75216_d()) {
            itemstack = slot.func_75211_c();
            itemstackPrev = itemstack.func_77946_l();
            switch (slotID) {
                case 2: {
                    if (this.func_75135_a(itemstack, 3, this.field_75151_b.size(), true)) break;
                    return ItemStack.field_190927_a;
                }
                case 0: 
                case 1: {
                    if (this.func_75135_a(itemstack, 3, this.field_75151_b.size(), true)) break;
                    return ItemStack.field_190927_a;
                }
                default: {
                    int slockToCheck;
                    ItemStack i = InventoryUtils.copyStackWithSize(itemstack, 1);
                    int n = slockToCheck = this.getTableInventory().isItemValid(1, i) ? 1 : 0;
                    if (((Slot)this.field_75151_b.get(slockToCheck)).func_75216_d() || !this.func_75135_a(i, slockToCheck, slockToCheck + 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                    itemstack.func_190918_g(1);
                }
            }
            if (itemstack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack.func_190916_E() == itemstackPrev.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(p, itemstack);
        }
        return itemstack;
    }
}

