/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.inventory;

import de.impelon.disenchanter.DisenchanterConfig;
import de.impelon.disenchanter.DisenchantingProperties;
import de.impelon.disenchanter.DisenchantingUtils;
import de.impelon.disenchanter.block.TableVariant;
import de.impelon.disenchanter.inventory.ContainerDisenchantmentBase;
import de.impelon.disenchanter.inventory.DisenchantmentItemStackHandler;
import de.impelon.disenchanter.inventory.IDisenchantmentItemHandler;
import de.impelon.disenchanter.inventory.InventoryUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerDisenchantmentManual
extends ContainerDisenchantmentBase {
    protected DisenchantmentItemStackHandler tableContent;
    protected long lastTimeChanged = this.world.func_82737_E();
    protected int disenchantingIndex = 0;
    protected boolean outputLocked = false;

    public ContainerDisenchantmentManual(InventoryPlayer playerInventory, World world, BlockPos position) {
        super(playerInventory, world, position);
    }

    @Override
    protected IDisenchantmentItemHandler getTableInventory() {
        if (this.tableContent == null) {
            this.tableContent = new DisenchantmentItemStackHandler(){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    ContainerDisenchantmentManual.this.onTableContentChanged(slot);
                }
            };
        }
        return this.tableContent;
    }

    public void func_75142_b() {
        DisenchantingProperties properties;
        super.func_75142_b();
        if (Math.abs(this.world.func_82737_E() - this.lastTimeChanged) >= (long)DisenchanterConfig.disenchanting.ticksCyclingDisenchanting && (properties = DisenchantingProperties.getPropertiesFromStateAt(this.world, this.position)) != null && properties.is(TableVariant.CYCLING)) {
            ++this.disenchantingIndex;
            this.lastTimeChanged = this.world.func_82737_E();
            this.updateOutput(true);
        }
    }

    public void func_75134_a(EntityPlayer p) {
        super.func_75134_a(p);
        if (!this.world.field_72995_K) {
            InventoryUtils.returnInventoryToPlayer(p, p.field_70170_p, this.getTableInventory());
        }
    }

    protected void onTableContentChanged(int slot) {
        if (slot != 2) {
            this.updateOutput(true);
            this.disenchantingIndex = 0;
            this.lastTimeChanged = this.world.func_82737_E();
        }
        this.func_75142_b();
    }

    public void updateOutput(boolean ignoreEnchantmentLoss) {
        if (!this.world.field_72995_K && !this.outputLocked) {
            DisenchantmentItemStackHandler virtualContent = new DisenchantmentItemStackHandler();
            virtualContent.setSourceStack(this.getTableInventory().getSourceStack().func_77946_l());
            virtualContent.setReceiverStack(this.getTableInventory().getReceiverStack().func_77946_l());
            ItemStack output = DisenchantingUtils.simulateDisenchantingInInventory((IDisenchantmentItemHandler)virtualContent, ignoreEnchantmentLoss, this.disenchantingIndex, this.world, this.position, this.world.field_73012_v);
            if (!output.func_190926_b()) {
                if (!ItemStack.func_77989_b((ItemStack)this.getTableInventory().getOutputStack(), (ItemStack)output)) {
                    this.getTableInventory().setOutputStack(output);
                }
            } else if (!this.getTableInventory().getOutputStack().func_190926_b()) {
                this.getTableInventory().setOutputStack(ItemStack.field_190927_a);
            }
        }
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickType, EntityPlayer player) {
        if (slot == 2 && clickType != ClickType.CLONE) {
            if (!this.world.field_72995_K) {
                this.updateOutput(false);
                this.outputLocked = true;
                boolean wasEmpty = this.getTableInventory().getOutputStack().func_190926_b();
                ItemStack result = super.func_184996_a(slot, dragType, clickType, player);
                if (this.getTableInventory().getOutputStack().func_190926_b() && !wasEmpty) {
                    DisenchantingUtils.disenchantInInventory(this.getTableInventory(), this.disenchantingIndex, this.world, this.position, this.world.field_73012_v);
                }
                this.outputLocked = false;
                this.updateOutput(true);
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a((Container)this);
                }
                return result;
            }
            if (clickType == ClickType.QUICK_MOVE) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slot, dragType, clickType, player);
    }
}

