/*
 * Decompiled with CFR 0.152.
 */
package de.impelon.disenchanter.item;

import de.impelon.disenchanter.DisenchanterConfig;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemExperienceJar
extends Item {
    public static final String STORED_EXPERIENCE_KEY = "StoredExperience";
    public static final String EXPERIENCE_CAPACITY_KEY = "ExperienceCapacity";
    public static final String OVERLOAD_MODE_KEY = "Overload";

    public ItemExperienceJar() {
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.setRegistryName("disenchanter", "experience_jar");
        this.func_77655_b(this.getRegistryName().toString().toLowerCase());
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("disenchanter", "fill_level"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entityIn) {
                ItemExperienceJar.ensureValidTag(stack);
                return ItemExperienceJar.getExperienceFillLevel(stack);
            }
        });
        this.func_185043_a(new ResourceLocation("disenchanter", "overloaded"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World world, EntityLivingBase entityIn) {
                ItemExperienceJar.ensureValidTag(stack);
                return ItemExperienceJar.isOverloadActive(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        super.func_150895_a(tab, subItems);
        if (tab == CreativeTabs.field_78027_g) {
            ItemStack fullJar = new ItemStack((Item)this);
            ItemExperienceJar.ensureValidTag(fullJar);
            ItemExperienceJar.setStoredExperience(fullJar, ItemExperienceJar.getExperienceCapacity(fullJar));
            subItems.add((Object)fullJar);
            ItemStack fullOverloadedJar = fullJar.func_77946_l();
            ItemExperienceJar.setOverload(fullOverloadedJar, true);
            subItems.add((Object)fullOverloadedJar);
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            ItemExperienceJar.giveExperienceTo(player, stack, player.func_70093_af());
        }
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        EntityPlayer player;
        if (DisenchanterConfig.experienceJar.playerCanInsertXPInJar && entityLiving instanceof EntityPlayer && (player = (EntityPlayer)entityLiving).func_70093_af()) {
            ItemExperienceJar.takeExperienceFrom(player, stack);
        }
        return super.onEntitySwing(entityLiving, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (DisenchanterConfig.experienceJar.playerCanExtractXPFromJar && ItemExperienceJar.hasStoredExperience(stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> l, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, l, advanced);
        if (ItemExperienceJar.isOverloadActive(stack)) {
            String overload = "msg.overload.txt";
            if (GuiScreen.func_146272_n()) {
                overload = "msg.overload_detailed.txt";
            }
            l.add(new TextComponentTranslation(overload, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)).func_150254_d());
        }
        l.add(new TextComponentTranslation("msg.stored_xp.txt", new Object[]{ItemExperienceJar.getStoredExperience(stack), ItemExperienceJar.getExperienceCapacity(stack)}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150254_d());
        if (DisenchanterConfig.experienceJar.playerCanExtractXPFromJar || DisenchanterConfig.experienceJar.playerCanInsertXPInJar) {
            if (GuiScreen.func_146272_n()) {
                if (DisenchanterConfig.experienceJar.playerCanExtractXPFromJar) {
                    l.add(new TextComponentTranslation("msg.extract_from_jar.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150254_d());
                    l.add(new TextComponentTranslation("msg.extract_all_from_jar.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150254_d());
                }
                if (DisenchanterConfig.experienceJar.playerCanInsertXPInJar) {
                    l.add(new TextComponentTranslation("msg.insert_into_jar.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150254_d());
                }
            } else {
                l.add(new TextComponentTranslation("msg.shift_for_tooltip.txt", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY).func_150217_b(Boolean.valueOf(true))).func_150254_d());
            }
        }
    }

    public static void giveExperienceTo(EntityPlayer player, ItemStack stack, boolean transferAll) {
        int amountToAdd = 0;
        ItemExperienceJar.ensureValidTag(stack);
        int xpStored = ItemExperienceJar.getStoredExperience(stack);
        if (transferAll) {
            amountToAdd = xpStored;
        } else {
            int xpToLevelup = MathHelper.func_76123_f((float)((float)player.func_71050_bK() * (1.0f - player.field_71106_cc)));
            amountToAdd = Math.min(xpToLevelup, xpStored);
        }
        player.func_71023_q(amountToAdd);
        ItemExperienceJar.setStoredExperience(stack, xpStored - amountToAdd);
    }

    public static void takeExperienceFrom(EntityPlayer player, ItemStack stack) {
        ItemExperienceJar.ensureValidTag(stack);
        int xpStored = ItemExperienceJar.getStoredExperience(stack);
        int capacity = ItemExperienceJar.getExperienceCapacity(stack);
        int xpToLeveldown = Math.round((float)player.func_71050_bK() * player.field_71106_cc);
        int amountToRemove = 0;
        if (xpToLeveldown > 0) {
            amountToRemove = xpToLeveldown;
        } else if (player.field_71068_ca > 0) {
            --player.field_71068_ca;
            amountToRemove = player.func_71050_bK();
        }
        if (amountToRemove > 0) {
            int amountRemoved = Math.min(amountToRemove, capacity - xpStored);
            ItemExperienceJar.setStoredExperience(stack, xpStored + amountRemoved);
            player.field_71106_cc = (float)(amountToRemove - amountRemoved) / (float)player.func_71050_bK();
        }
    }

    public static boolean ensureValidTag(ItemStack stack) {
        boolean modified = false;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            modified = true;
        }
        if (!ItemExperienceJar.isOverloadActive(stack)) {
            ItemExperienceJar.setOverload(stack, false);
            modified = true;
        }
        if (ItemExperienceJar.getExperienceCapacity(stack) <= 0) {
            ItemExperienceJar.resetExperienceCapacity(stack);
            modified = true;
        }
        if (!ItemExperienceJar.hasStoredExperience(stack)) {
            ItemExperienceJar.setStoredExperience(stack, 0);
            modified = true;
        } else if (ItemExperienceJar.getExperienceFillLevel(stack) > 1.0f) {
            ItemExperienceJar.setStoredExperience(stack, ItemExperienceJar.getExperienceCapacity(stack));
            modified = true;
        }
        return modified;
    }

    public static boolean isOverloadActive(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n(OVERLOAD_MODE_KEY);
        }
        return false;
    }

    public static boolean setOverload(ItemStack stack, boolean active) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74757_a(OVERLOAD_MODE_KEY, active);
            return true;
        }
        return false;
    }

    public static boolean hasAvailableExperienceCapacity(ItemStack stack) {
        return ItemExperienceJar.getExperienceFillLevel(stack) < 1.0f;
    }

    public static float getExperienceFillLevel(ItemStack stack) {
        int capacity = ItemExperienceJar.getExperienceCapacity(stack);
        if (capacity == 0) {
            return 0.0f;
        }
        return (float)ItemExperienceJar.getStoredExperience(stack) / (float)capacity;
    }

    public static int getExperienceCapacity(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(EXPERIENCE_CAPACITY_KEY);
        }
        return 0;
    }

    public static boolean setExperienceCapacity(ItemStack stack, int capacity) {
        if (stack.func_77942_o() && capacity >= 0) {
            stack.func_77978_p().func_74768_a(EXPERIENCE_CAPACITY_KEY, capacity);
            return true;
        }
        return false;
    }

    public static boolean resetExperienceCapacity(ItemStack stack) {
        return ItemExperienceJar.setExperienceCapacity(stack, DisenchanterConfig.experienceJar.jarDefaultExperienceCapacity);
    }

    public static boolean hasStoredExperience(ItemStack stack) {
        return ItemExperienceJar.getStoredExperience(stack) > 0;
    }

    public static int getStoredExperience(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74762_e(STORED_EXPERIENCE_KEY);
        }
        return 0;
    }

    public static boolean setStoredExperience(ItemStack stack, int amount) {
        if (stack.func_77942_o() && amount >= 0 && amount <= ItemExperienceJar.getExperienceCapacity(stack)) {
            stack.func_77978_p().func_74768_a(STORED_EXPERIENCE_KEY, amount);
            return true;
        }
        return false;
    }

    public static boolean setStoredExperienceClamped(ItemStack stack, int amount) {
        return ItemExperienceJar.setStoredExperience(stack, MathHelper.func_76125_a((int)amount, (int)0, (int)ItemExperienceJar.getExperienceCapacity(stack)));
    }
}

