/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.asm;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import kotlin.collections.CollectionsKt;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class ASMUtil {
    static boolean isObfuscated;

    public static ClassNode createClassNode(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static InsnList createInsnList(Consumer<InsnList> fill) {
        InsnList list2 = new InsnList();
        fill.accept(list2);
        return list2;
    }

    public static MethodNode findMethod(ClassNode classNode, String srgName, String mcpName, @Nullable String desc) {
        String actualName = isObfuscated ? srgName : mcpName;
        MethodNode method = (MethodNode)CollectionsKt.firstOrNull((List)CollectionsKt.filter((Iterable)classNode.methods, node -> node.name.equals(actualName) && (desc == null || node.desc.equals(desc))));
        if (method != null) {
            return method;
        }
        System.err.println("******************************");
        System.err.println("REPORT THIS TO FUTUREMC GITHUB");
        System.err.println("******************************");
        throw new NoSuchMethodError("Class bytecode did not contain expected method " + srgName + " or " + mcpName + " (expected: " + actualName + ")");
    }

    public static byte[] patchBeforeReturnTrue(ClassNode classNode, MethodNode method, InsnList toAdd) {
        return ASMUtil.patchBeforeInsn(classNode, method, toAdd, 1, node -> node.getOpcode() == 172 && node.getPrevious().getOpcode() == 4);
    }

    public static byte[] patchBeforeMcMethod(ClassNode classNode, MethodNode method, InsnList toAdd, String srgName, String mcpName, int occurrence) {
        return ASMUtil.patchBeforeInsn(classNode, method, toAdd, occurrence, node -> {
            String actualName;
            String string = actualName = isObfuscated ? srgName : mcpName;
            if (node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                return methodNode.name.equals(actualName);
            }
            return false;
        });
    }

    public static byte[] patchBeforeInsn(ClassNode classNode, MethodNode method, InsnList toAdd, int occurrence, Predicate<AbstractInsnNode> condition) {
        int[] occurrences = new int[]{0};
        AbstractInsnNode insn = ASMUtil.findInsn(method, condition.and(node -> {
            occurrences[0] = occurrences[0] + 1;
            return occurrences[0] == occurrence;
        }));
        method.instructions.insertBefore(insn, toAdd);
        return ASMUtil.compile(classNode);
    }

    public static MethodInsnNode findMethodInsn(MethodNode methodNode, String srgName, String mcpName, @Nullable String desc) {
        String actualName = isObfuscated ? srgName : mcpName;
        AbstractInsnNode insn = ASMUtil.findInsn(methodNode, node -> {
            if (node instanceof MethodInsnNode) {
                MethodInsnNode method = (MethodInsnNode)node;
                return method.name.equals(actualName) && (desc == null || desc.equals(method.name));
            }
            return false;
        });
        return (MethodInsnNode)insn;
    }

    public static AbstractInsnNode findInsn(MethodNode methodNode, Predicate<AbstractInsnNode> condition) {
        for (AbstractInsnNode node : methodNode.instructions.toArray()) {
            if (!condition.test(node)) continue;
            return node;
        }
        throw new RuntimeException("Could not find matching instruction in bytecode");
    }

    public static byte[] compile(ClassNode classNode) {
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static byte[] compile(ClassNode classNode, int args) {
        ClassWriter cw = new ClassWriter(args);
        try {
            classNode.accept((ClassVisitor)cw);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        return cw.toByteArray();
    }
}

