/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.compat.crafttweaker;

import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thedarkcolour.futuremc.compat.crafttweaker.RecipeUtil;
import thedarkcolour.futuremc.recipe.Recipes;
import thedarkcolour.futuremc.recipe.SimpleRecipe;
import thedarkcolour.futuremc.recipe.furnace.BlastFurnaceRecipes;
import thedarkcolour.futuremc.recipe.furnace.SmokerRecipes;

public class SmokerAndBlastFurnace {

    private static final class RemoveRecipeForOutput
    extends RemoveRecipeFor {
        private RemoveRecipeForOutput(Recipes<SimpleRecipe> recipes, IItemStack input) {
            super(recipes, input);
        }

        public void apply() {
            this.recipes.removeRecipeForInput(this.item);
        }
    }

    private static final class RemoveRecipeForInput
    extends RemoveRecipeFor {
        private RemoveRecipeForInput(Recipes<SimpleRecipe> recipes, IItemStack input) {
            super(recipes, input);
        }

        public void apply() {
            this.recipes.removeRecipeForInput(this.item);
        }
    }

    private static abstract class RemoveRecipeFor
    implements IAction {
        protected final Recipes<SimpleRecipe> recipes;
        protected final ItemStack item;

        private RemoveRecipeFor(Recipes<SimpleRecipe> recipes, IItemStack item) {
            this.recipes = recipes;
            this.item = RecipeUtil.toItemStack(item);
        }

        public String describe() {
            return this.recipes.getClass().getSimpleName() + ": " + this.getClass().getSimpleName() + " " + this.item.func_77973_b().getRegistryName();
        }
    }

    private static final class AddRecipe
    implements IAction {
        private final Recipes<SimpleRecipe> recipes;
        private final ItemStack input;
        private final ItemStack output;

        private AddRecipe(Recipes<SimpleRecipe> recipes, IItemStack input, IItemStack output) {
            this.recipes = recipes;
            this.input = RecipeUtil.toItemStack(input);
            this.output = RecipeUtil.toItemStack(output);
        }

        public void apply() {
            this.recipes.addRecipe(this.input, this.output);
        }

        public String describe() {
            return this.recipes.getClass().getSimpleName() + ": Adding recipe (input: " + this.input.toString() + ") -> (output: " + this.output.toString() + ")";
        }
    }

    @ZenRegister
    @ZenClass(value="mods.futuremc.BlastFurnace")
    public static final class BlastFurnace {
        @ZenMethod
        public static void addRecipe(IItemStack input, IItemStack output) {
            RecipeUtil.applyAction(new AddRecipe(BlastFurnaceRecipes.INSTANCE, input, output));
        }

        @ZenMethod
        public static void addRecipe(IOreDictEntry input, IItemStack output) {
            for (IItemStack i2 : input.getItems()) {
                BlastFurnace.addRecipe(i2, output);
            }
        }

        @ZenMethod
        public static void removeRecipe(IItemStack input) {
            RecipeUtil.applyAction(new RemoveRecipeForInput(BlastFurnaceRecipes.INSTANCE, input));
        }

        @ZenMethod
        public static void removeRecipeForInput(IItemStack input) {
            BlastFurnace.removeRecipe(input);
        }

        @ZenMethod
        public static void removeRecipeForOutput(IItemStack output) {
            RecipeUtil.applyAction(new RemoveRecipeForOutput(BlastFurnaceRecipes.INSTANCE, output));
        }

        @ZenMethod
        public static void clearRecipes() {
            BlastFurnaceRecipes.INSTANCE.clear();
        }
    }

    @ZenRegister
    @ZenClass(value="mods.futuremc.Smoker")
    public static final class Smoker {
        @ZenMethod
        public static void addRecipe(IItemStack input, IItemStack output) {
            RecipeUtil.applyAction(new AddRecipe(SmokerRecipes.INSTANCE, input, output));
        }

        @ZenMethod
        public static void addRecipe(IOreDictEntry input, IItemStack output) {
            for (IItemStack i2 : input.getItems()) {
                Smoker.addRecipe(i2, output);
            }
        }

        @ZenMethod
        public static void removeRecipe(IItemStack input) {
            RecipeUtil.applyAction(new RemoveRecipeForInput(SmokerRecipes.INSTANCE, input));
        }

        @ZenMethod
        public static void removeRecipeForInput(IItemStack input) {
            Smoker.removeRecipe(input);
        }

        @ZenMethod
        public static void removeRecipeForOutput(IItemStack output) {
            RecipeUtil.applyAction(new RemoveRecipeForOutput(SmokerRecipes.INSTANCE, output));
        }

        @ZenMethod
        public static void clearRecipes() {
            SmokerRecipes.INSTANCE.clear();
        }
    }
}

