/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.entity.bee;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import kotlin.collections.CollectionsKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.api.BeePollinationHandler;
import thedarkcolour.futuremc.api.BeePollinationHandlerJVM;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FSounds;
import thedarkcolour.futuremc.tile.BeeHiveTile;

public class EntityBee
extends EntityAnimal
implements EntityFlying {
    private static final DataParameter<Byte> BEE_FLAGS = EntityDataManager.func_187226_a(EntityBee.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> ANGER = EntityDataManager.func_187226_a(EntityBee.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final List<IBlockState> FLOWERS = Lists.newArrayList((Object[])new IBlockState[]{FBlocks.CORNFLOWER.func_176223_P(), FBlocks.LILY_OF_THE_VALLEY.func_176223_P(), FBlocks.WITHER_ROSE.func_176223_P(), Blocks.field_150327_N.func_176223_P().func_177226_a(Blocks.field_150327_N.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.DANDELION), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.POPPY), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.BLUE_ORCHID), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ALLIUM), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.RED_TULIP), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.ORANGE_TULIP), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.WHITE_TULIP), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.PINK_TULIP), Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.OXEYE_DAISY)});
    private UUID targetPlayer;
    private float currentPitch;
    private float lastPitch;
    private int ticksSinceSting;
    private int ticksSincePollination;
    private int cannotEnterHiveTicks;
    private int cropsGrownSincePollination;
    @Nullable
    private BlockPos flowerPos = null;
    @Nullable
    private BlockPos hivePos = null;

    public EntityBee(World worldIn) {
        super(worldIn);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
        this.field_70749_g = new LookHelper(this);
        this.func_70105_a(0.7f, 0.7f);
        this.func_70105_a(0.7f, 0.7f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    public static boolean isFlowerValid(IBlockState state) {
        return FLOWERS.contains(state);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BEE_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(ANGER, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIFindHive(this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AISting(this, 1.4f, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIEnterHive(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AITempt(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIPollinate(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIMoveToHive(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveToFlower(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIGrowCrops(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIWander(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIRevenge(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIFollowTarget(this));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.hivePos != null) {
            compound.func_74782_a("HivePos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.hivePos));
        }
        if (this.flowerPos != null) {
            compound.func_74782_a("FlowerPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.flowerPos));
        }
        compound.func_74757_a("HasNectar", this.hasNectar());
        compound.func_74757_a("HasStung", this.hasStung());
        compound.func_74768_a("TicksSincePollination", this.ticksSincePollination);
        compound.func_74768_a("CannotEnterHiveTicks", this.cannotEnterHiveTicks);
        compound.func_74768_a("CropsGrownSincePollination", this.cropsGrownSincePollination);
        compound.func_74768_a("Anger", this.getAnger());
        if (this.targetPlayer != null) {
            compound.func_74778_a("HurtBy", this.targetPlayer.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        if (compound.func_74764_b("HivePos")) {
            this.hivePos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("HivePos"));
        }
        if (compound.func_74764_b("FlowerPos")) {
            this.flowerPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("FlowerPos"));
        }
        super.func_70037_a(compound);
        this.setHasNectar(compound.func_74767_n("HasNectar"));
        this.setHasStung(compound.func_74767_n("HasStung"));
        this.setAnger(compound.func_74762_e("Anger"));
        this.ticksSincePollination = compound.func_74762_e("TicksSincePollination");
        this.cannotEnterHiveTicks = compound.func_74762_e("CannotEnterHiveTicks");
        this.cropsGrownSincePollination = compound.func_74762_e("CropsGrownSincePollination");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.targetPlayer = UUID.fromString(s);
            EntityPlayer player = this.field_70170_p.func_152378_a(this.targetPlayer);
            this.func_70604_c((EntityLivingBase)player);
            if (player != null) {
                this.field_70717_bb = player;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a((DamageSource)EntityBee.causeBeeDamage(this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            if (entityIn instanceof EntityLivingBase) {
                int duration = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    duration = 10;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    duration = 18;
                }
                if (duration > 0) {
                    ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration * 20, 0));
                }
            }
            this.setHasStung(true);
            this.func_70624_b(null);
            this.func_184185_a(FSounds.BEE_STING, 1.0f, 1.0f);
        }
        return flag;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateBodyPitch();
    }

    @Nullable
    public BlockPos getFlowerPos() {
        return this.flowerPos;
    }

    @Nullable
    public BlockPos getHivePos() {
        return this.hivePos;
    }

    public boolean hasFlower() {
        return this.flowerPos != null;
    }

    public void setFlowerPos(BlockPos flowerPos) {
        this.flowerPos = flowerPos;
    }

    public boolean canEnterHive() {
        if (this.cannotEnterHiveTicks > 0) {
            return false;
        }
        if (!this.hasHive()) {
            return false;
        }
        return this.hasNectar() || this.field_70170_p.func_72935_r() || this.field_70170_p.func_175727_C(this.func_180425_c()) || this.ticksSincePollination > 3600;
    }

    public void setCannotEnterHiveTicks(int cannotEnterHiveTicks) {
        this.cannotEnterHiveTicks = cannotEnterHiveTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public float getBodyPitch(float partialTickTime) {
        return this.lastPitch + partialTickTime * (this.currentPitch - this.lastPitch);
    }

    private void updateBodyPitch() {
        this.lastPitch = this.currentPitch;
        this.currentPitch = this.isNearTarget() ? Math.min(1.0f, this.currentPitch + 0.2f) : Math.max(0.0f, this.currentPitch - 0.24f);
    }

    public void func_70604_c(EntityLivingBase entityIn) {
        super.func_70604_c(entityIn);
        if (entityIn != null) {
            this.targetPlayer = entityIn.func_110124_au();
        }
    }

    protected void func_70619_bc() {
        if (this.hasStung()) {
            ++this.ticksSinceSting;
            if (this.ticksSinceSting % 5 == 0 && this.field_70146_Z.nextInt(MathHelper.func_76125_a((int)(1200 - this.ticksSinceSting), (int)1, (int)1200)) == 0) {
                this.func_70097_a(DamageSource.field_76377_j, this.func_110143_aJ());
            }
        }
        if (this.isAngry()) {
            int anger = this.getAnger();
            this.setAnger(anger - 1);
            EntityLivingBase livingEntity_1 = this.func_70638_az();
            if (anger == 0 && livingEntity_1 != null) {
                this.setBeeAttacker((Entity)livingEntity_1);
            }
        }
        if (!this.hasNectar()) {
            ++this.ticksSincePollination;
        }
    }

    public void resetPollinationTicks() {
        this.ticksSincePollination = 0;
    }

    public boolean isAngry() {
        return this.getAnger() > 0;
    }

    public int getAnger() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER);
    }

    public void setAnger(int anger) {
        this.field_70180_af.func_187227_b(ANGER, (Object)anger);
    }

    public boolean hasHive() {
        return this.hivePos != null;
    }

    public int getCropsGrownSincePollination() {
        return this.cropsGrownSincePollination;
    }

    public void resetCropCounter() {
        this.cropsGrownSincePollination = 0;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.cannotEnterHiveTicks > 0) {
                --this.cannotEnterHiveTicks;
            }
            if (this.isPollinating() && !this.func_70781_l()) {
                Vec3d vec3d;
                float f;
                float f2 = f = this.field_70146_Z.nextBoolean() ? 2.0f : -2.0f;
                if (this.hasFlower()) {
                    BlockPos pos = this.flowerPos.func_177963_a(0.0, (double)f, 0.0);
                    vec3d = new Vec3d((Vec3i)pos);
                } else {
                    vec3d = this.func_174791_d().func_72441_c(0.0, (double)f, 0.0);
                }
                this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, (double)0.4f);
            }
            this.setNearTarget(this.isAngry() && !this.hasStung() && this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 4.0);
            if (this.hasHive() && this.field_70173_aa % 20 == 0 && !this.isHiveValid()) {
                this.hivePos = null;
            }
        }
    }

    private boolean isHiveValid() {
        if (!this.hasHive()) {
            return false;
        }
        TileEntity te = this.field_70170_p.func_175625_s(this.hivePos);
        return te instanceof BeeHiveTile;
    }

    public boolean hasNectar() {
        return this.getBeeFlag(8);
    }

    public void setHasNectar(boolean hasNectar) {
        this.setBeeFlag(8, hasNectar);
    }

    public boolean hasStung() {
        return this.getBeeFlag(4);
    }

    public void setHasStung(boolean hasStung) {
        this.setBeeFlag(4, hasStung);
    }

    public boolean isNearTarget() {
        return this.getBeeFlag(2);
    }

    public void setNearTarget(boolean isNearTarget) {
        this.setBeeFlag(2, isNearTarget);
    }

    public boolean isPollinating() {
        return this.getBeeFlag(1);
    }

    public void setPollinating(boolean isPollinating) {
        this.setBeeFlag(1, isPollinating);
    }

    public void setBeeFlag(int flag, boolean bool) {
        byte b = (Byte)this.field_70180_af.func_187225_a(BEE_FLAGS);
        if (bool) {
            this.field_70180_af.func_187227_b(BEE_FLAGS, (Object)((byte)(b | flag)));
        } else {
            this.field_70180_af.func_187227_b(BEE_FLAGS, (Object)((byte)(b & ~flag)));
        }
    }

    public boolean getBeeFlag(int i2) {
        return ((Byte)this.field_70180_af.func_187225_a(BEE_FLAGS) & i2) != 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected PathNavigate func_175447_b(final World worldIn) {
        PathNavigateFlying navigateFlying = new PathNavigateFlying((EntityLiving)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150350_a;
            }
        };
        navigateFlying.func_192879_a(false);
        navigateFlying.func_192878_b(true);
        navigateFlying.func_192877_c(false);
        return navigateFlying;
    }

    public boolean func_70877_b(ItemStack stack) {
        return EntityBee.isFlowerValid(Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j()));
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    protected SoundEvent func_184639_G() {
        return this.isAngry() ? FSounds.BEE_AGGRESSIVE : FSounds.BEE_PASSIVE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FSounds.BEE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FSounds.BEE_DEATH;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityBee(this.field_70170_p);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public void onHoneyDelivered() {
        this.setHasNectar(false);
        this.resetCropCounter();
    }

    private List<BlockPos> getBlockInRange(Predicate<BlockPos> predicate, int range) {
        ArrayList list2 = CollectionsKt.arrayListOf((Object[])new BlockPos[0]);
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177982_a(-range, -range, -range), (BlockPos)this.func_180425_c().func_177982_a(range, range, range))) {
            if (!predicate.test(pos)) continue;
            list2.add(pos.func_185334_h());
        }
        if (list2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collections.shuffle(list2);
        return list2;
    }

    public boolean setBeeAttacker(Entity entity) {
        return this.setBeeAttacker(entity, 400);
    }

    public boolean setBeeAttacker(Entity entity, int angerTicks) {
        this.setAnger(angerTicks + this.field_70146_Z.nextInt(400));
        if (entity instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)entity);
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity attacker = source.func_76346_g();
        if (attacker instanceof EntityPlayer && !((EntityPlayer)attacker).func_184812_l_() && this.func_70685_l(attacker)) {
            this.setPollinating(false);
            this.setBeeAttacker(attacker);
        }
        return super.func_70097_a(source, amount);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public static EntityDamageSource causeBeeDamage(EntityBee entityBee) {
        return new EntityDamageSource("sting", (Entity)entityBee);
    }

    public static Vec3d findVector(EntityCreature entityIn, int var1, int var2, Vec3d vec3d, double var4) {
        return EntityBee.findVector(entityIn, var1, var2, vec3d.func_178788_d(entityIn.func_174791_d()), true, var4, arg_0 -> ((EntityCreature)entityIn).func_180484_a(arg_0));
    }

    public static Vec3d findVector(EntityCreature entityIn, int var1, int var2, Vec3d vec3d, boolean var4, double var5, ToDoubleFunction<BlockPos> function) {
        return EntityBee.findVector(entityIn, var1, var2, 0, vec3d, var4, var5, function, !var4, pos -> entityIn.field_70170_p.func_180495_p(pos).func_185904_a().func_76220_a(), 0, 0, true);
    }

    public static Vec3d findVector(EntityCreature entityIn, int var1, int var2, int var3, Vec3d vec3d, boolean var5, double var6, ToDoubleFunction<BlockPos> function, boolean var8, Predicate<BlockPos> posPredicate, int var10, int var11, boolean var12) {
        PathNavigate navigator = entityIn.func_70661_as();
        Random rand = entityIn.func_70681_au();
        boolean flag = entityIn.func_110175_bO() ? entityIn.func_180486_cf().func_177951_i((Vec3i)entityIn.func_180425_c()) < ((double)(entityIn.func_110174_bM() + (float)var1) + 1.0) * ((double)(entityIn.func_110174_bM() + (float)var1) + 1.0) : false;
        boolean flag1 = false;
        double d0 = Double.NEGATIVE_INFINITY;
        BlockPos pos = new BlockPos((Entity)entityIn);
        for (int i2 = 0; i2 < 10; ++i2) {
            double double_3;
            BlockPos pos2;
            BlockPos pos1 = EntityBee.getRandomOffset(rand, var1, var2, var3, vec3d, var6);
            if (pos1 == null) continue;
            int x = pos1.func_177958_n();
            int y = pos1.func_177956_o();
            int z = pos1.func_177952_p();
            if (entityIn.func_110175_bO() && var1 > 1) {
                pos2 = entityIn.func_180486_cf();
                x = entityIn.field_70165_t > (double)pos2.func_177958_n() ? (x -= rand.nextInt(var1 / 2)) : (x += rand.nextInt(var1 / 2));
                z = entityIn.field_70161_v > (double)pos2.func_177952_p() ? (z -= rand.nextInt(var1 / 2)) : (z += rand.nextInt(var1 / 2));
            }
            pos2 = new BlockPos((double)x + entityIn.field_70165_t, (double)y + entityIn.field_70163_u, (double)z + entityIn.field_70161_v);
            if (flag && !entityIn.func_180485_d(pos2) || var12 && !navigator.func_188555_b(pos2)) continue;
            if (var8) {
                pos2 = EntityBee.findValidPositionAbove(pos2, rand.nextInt(var10 + 1) + var11, entityIn.field_70170_p.func_72800_K(), posPredicate);
            }
            if (!var5 && entityIn.field_70170_p.func_180495_p(pos2).func_185904_a() == Material.field_151586_h || !((double_3 = function.applyAsDouble(pos2)) > d0)) continue;
            d0 = double_3;
            pos = pos2;
            flag1 = true;
        }
        if (flag1) {
            return new Vec3d((Vec3i)pos);
        }
        return null;
    }

    @Nullable
    public static Vec3d findVector(@NotNull EntityCreature entityIn, int var1, int var2, @NotNull Vec3d vec3d) {
        Vec3d vec = vec3d.func_178788_d(entityIn.func_174791_d());
        return EntityBee.findVector(entityIn, var1, var2, vec, true, 1.5707963267948966, arg_0 -> ((EntityCreature)entityIn).func_180484_a(arg_0));
    }

    @Nullable
    private static BlockPos getRandomOffset(Random random, int var1, int var2, int var3, Vec3d vec3d, double var5) {
        if (vec3d != null && var5 < Math.PI) {
            double d0 = MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) - 1.5707963267948966;
            double d1 = d0 + (double)(2.0f * random.nextFloat() - 1.0f) * var5;
            double d2 = Math.sqrt(random.nextDouble()) * (double)MathHelper.field_180189_a * (double)var1;
            double d3 = -d2 * Math.sin(d1);
            double d4 = d2 * Math.cos(d1);
            if (Math.abs(d3) <= (double)var1 && Math.abs(d4) <= (double)var1) {
                int y = random.nextInt(2 * var2 + 1) - var2 + var3;
                return new BlockPos(d3, (double)y, d4);
            }
            return null;
        }
        int x = random.nextInt(2 * var1 + 1) - var1;
        int y = random.nextInt(2 * var2 + 1) - var2 + var3;
        int z = random.nextInt(2 * var1 + 1) - var1;
        return new BlockPos(x, y, z);
    }

    private static BlockPos findValidPositionAbove(BlockPos pos, int aboveSolidAmount, int heightLimit, Predicate<BlockPos> condition) {
        if (aboveSolidAmount < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + aboveSolidAmount + ", expected >= 0");
        }
        if (!condition.test(pos)) {
            return pos;
        }
        BlockPos blockPos = pos.func_177984_a();
        while (blockPos.func_177956_o() < heightLimit && condition.test(blockPos)) {
            blockPos = blockPos.func_177984_a();
        }
        BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos(blockPos);
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos(blockPos);
        while (pos1.func_177956_o() < heightLimit && pos1.func_177956_o() - pos.func_177956_o() < aboveSolidAmount) {
            pos2.func_189536_c(EnumFacing.UP);
            if (condition.test((BlockPos)pos2)) break;
            pos1.func_189533_g((Vec3i)pos2);
        }
        return pos1.func_185334_h();
    }

    private static final class FlyHelper
    extends EntityMoveHelper {
        private final EntityBee entityBee;

        private FlyHelper(EntityBee entityBee) {
            super((EntityLiving)entityBee);
            this.entityBee = entityBee;
        }

        public void func_75641_c() {
            if (!this.entityBee.isPollinating()) {
                if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    this.field_75648_a.func_189654_d(true);
                    double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                    double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                    double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (d3 < 2.500000277905201E-7) {
                        this.field_75648_a.func_70657_f(0.0f);
                        this.field_75648_a.func_191989_p(0.0f);
                        return;
                    }
                    float f0 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f0, 10.0f);
                    float f1 = this.field_75648_a.field_70122_E ? (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()) : (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e());
                    this.field_75648_a.func_70659_e(f1);
                    double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    float f2 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d4) * 57.2957763671875));
                    this.field_75648_a.field_70125_A = this.func_75639_a(this.field_75648_a.field_70125_A, f2, 10.0f);
                    this.field_75648_a.func_70657_f(d1 > 0.0 ? f1 : -f1);
                } else {
                    this.field_75648_a.func_189654_d(false);
                    this.field_75648_a.func_70657_f(0.0f);
                    this.field_75648_a.func_191989_p(0.0f);
                }
            }
        }
    }

    private static final class AITempt
    extends EntityAIBase {
        private final EntityBee bee;
        private EntityPlayer closestPlayer;
        private int coolDown;

        private AITempt(EntityBee bee) {
            this.bee = bee;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            if (this.coolDown > 0) {
                --this.coolDown;
                return false;
            }
            this.closestPlayer = this.bee.field_70170_p.func_72890_a((Entity)this.bee, 10.0);
            if (this.closestPlayer == null) {
                return false;
            }
            return AITempt.isTempting(this.closestPlayer.func_184614_ca()) || AITempt.isTempting(this.closestPlayer.func_184592_cb());
        }

        private static boolean isTempting(ItemStack stack) {
            return EntityBee.isFlowerValid(Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77960_j()));
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75251_c() {
            this.closestPlayer = null;
            this.bee.func_70661_as().func_75499_g();
            this.coolDown = 100;
        }

        public void func_75246_d() {
            this.bee.func_70671_ap().func_75651_a((Entity)this.closestPlayer, 75.0f, 40.0f);
            if (this.bee.func_70068_e((Entity)this.closestPlayer) < 6.25) {
                this.bee.func_70661_as().func_75499_g();
            } else {
                this.bee.func_70661_as().func_75497_a((Entity)this.closestPlayer, 1.25);
            }
        }
    }

    private static final class AIRevenge
    extends EntityAIHurtByTarget {
        private AIRevenge(EntityBee entityBee) {
            super((EntityCreature)entityBee, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof EntityBee && this.field_75299_d.func_70685_l((Entity)entityLivingBaseIn) && ((EntityBee)creatureIn).setBeeAttacker((Entity)entityLivingBaseIn)) {
                creatureIn.func_70624_b(entityLivingBaseIn);
            }
        }
    }

    private static final class AIFollowTarget
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        private AIFollowTarget(EntityBee entityBee) {
            super((EntityCreature)entityBee, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return this.canSting() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            if (this.canSting() && this.field_75299_d.func_70638_az() != null) {
                return super.func_75253_b();
            }
            this.field_188509_g = null;
            return false;
        }

        private boolean canSting() {
            EntityBee bee = (EntityBee)this.field_75299_d;
            return bee.isAngry() && !bee.hasStung();
        }
    }

    private static abstract class AINotAngry
    extends EntityAIBase {
        protected final EntityBee bee;

        private AINotAngry(EntityBee bee) {
            this.bee = bee;
        }

        public abstract boolean canBeeStart();

        public abstract boolean canBeeContinue();

        public boolean func_75250_a() {
            return this.canBeeStart() && !this.bee.isAngry();
        }

        public boolean func_75253_b() {
            return this.canBeeContinue() && !this.bee.isAngry();
        }
    }

    private static final class AIWander
    extends EntityAIBase {
        private final EntityBee bee;

        private AIWander(EntityBee bee) {
            this.func_75248_a(1);
            this.bee = bee;
        }

        public boolean func_75250_a() {
            return this.bee.field_70699_by.func_75500_f() && this.bee.field_70146_Z.nextInt(10) == 0;
        }

        public boolean func_75253_b() {
            return !this.bee.field_70699_by.func_75500_f();
        }

        public void func_75249_e() {
            Vec3d vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.bee, (int)8, (int)7);
            if (this.bee.hivePos != null && this.bee.hivePos.func_177951_i((Vec3i)this.bee.func_180425_c()) >= 484.0) {
                vec3d = new Vec3d((Vec3i)this.bee.hivePos).func_178788_d(new Vec3d((Vec3i)this.bee.func_180425_c())).func_72432_b();
                this.bee.field_70699_by.func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                return;
            }
            if (vec3d != null) {
                this.bee.field_70699_by.func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            }
        }

        public void func_75251_c() {
            this.bee.field_70699_by.func_75484_a(null, 1.0);
        }
    }

    private static abstract class AIMoveToBlock
    extends AINotAngry {
        protected boolean failedToFindPath = false;
        protected int range;

        private AIMoveToBlock(EntityBee bee, int range) {
            super(bee);
            this.range = range;
            this.func_75248_a(1);
        }

        @Nullable
        protected abstract BlockPos getTargetPos();

        @Override
        public boolean canBeeContinue() {
            return this.getTargetPos().func_177951_i((Vec3i)this.bee.func_180425_c()) > (double)(this.range * this.range);
        }

        public void func_75246_d() {
            boolean flag;
            BlockPos pos = this.getTargetPos();
            boolean bl = flag = pos.func_177951_i((Vec3i)this.bee.func_180425_c()) < 64.0;
            if (this.bee.func_70661_as().func_75500_f()) {
                Vec3d vec3d = EntityBee.findVector((EntityCreature)this.bee, 8, 6, new Vec3d((Vec3i)pos), 0.3141592741012573);
                if (vec3d == null) {
                    vec3d = EntityBee.findVector((EntityCreature)this.bee, 3, 3, new Vec3d((Vec3i)pos));
                }
                if (vec3d != null && !flag && this.bee.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_177230_c() != Blocks.field_150355_j) {
                    vec3d = EntityBee.findVector((EntityCreature)this.bee, 8, 6, new Vec3d((Vec3i)pos));
                }
                if (vec3d == null) {
                    this.failedToFindPath = true;
                    return;
                }
                this.bee.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
            }
        }
    }

    private static final class AIMoveToHive
    extends AIMoveToBlock {
        private AIMoveToHive(EntityBee bee) {
            super(bee, 2);
        }

        @Override
        protected BlockPos getTargetPos() {
            return this.bee.hivePos;
        }

        @Override
        public boolean canBeeStart() {
            return this.bee.canEnterHive();
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart() && super.canBeeContinue();
        }
    }

    private static final class AIMoveToFlower
    extends AIMoveToBlock {
        private AIMoveToFlower(EntityBee bee) {
            super(bee, 3);
        }

        @Override
        public boolean canBeeStart() {
            return this.bee.hasFlower() && this.bee.ticksSincePollination > 3600;
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart() && super.canBeeContinue();
        }

        public void func_75251_c() {
            if (!EntityBee.isFlowerValid(this.bee.field_70170_p.func_180495_p(this.bee.flowerPos))) {
                this.bee.flowerPos = null;
            }
        }

        @Override
        protected BlockPos getTargetPos() {
            return this.bee.flowerPos;
        }
    }

    private static final class LookHelper
    extends EntityLookHelper {
        private final EntityBee bee;

        private LookHelper(EntityBee bee) {
            super((EntityLiving)bee);
            this.bee = bee;
        }

        public void func_75649_a() {
            if (!this.bee.isAngry()) {
                super.func_75649_a();
            }
        }
    }

    private static final class AIPollinate
    extends AINotAngry {
        private int lastPollinationTicks = 0;
        private int pollinationTicks = 0;

        private AIPollinate(EntityBee bee) {
            super(bee);
            this.func_75248_a(1);
        }

        @Override
        public boolean canBeeStart() {
            if (this.bee.hasNectar()) {
                return false;
            }
            if (this.bee.field_70146_Z.nextFloat() < 0.7f) {
                return false;
            }
            BlockPos flower = this.getFlower();
            if (flower != null) {
                this.bee.flowerPos = flower;
                this.bee.field_70765_h.func_75642_a((double)flower.func_177958_n() + 0.5, (double)flower.func_177956_o() + 0.5, (double)flower.func_177952_p() + 0.5, 1.2);
                return true;
            }
            return false;
        }

        @Override
        public boolean canBeeContinue() {
            if (this.completedPollination()) {
                return this.bee.field_70146_Z.nextFloat() < 0.2f;
            }
            if (this.bee.field_70173_aa % 20 == 0) {
                BlockPos flower = this.getFlower();
                return flower != null;
            }
            return true;
        }

        private boolean completedPollination() {
            return this.pollinationTicks > 400;
        }

        public void func_75249_e() {
            this.bee.setPollinating(true);
            this.pollinationTicks = 0;
            this.lastPollinationTicks = 0;
        }

        public void func_75251_c() {
            this.bee.setPollinating(false);
            if (this.completedPollination()) {
                this.bee.setHasNectar(true);
            }
        }

        public void func_75246_d() {
            ++this.pollinationTicks;
            if (this.bee.field_70146_Z.nextFloat() < 0.05f && this.pollinationTicks > this.lastPollinationTicks + 60) {
                this.lastPollinationTicks = this.pollinationTicks;
                this.bee.func_184185_a(FSounds.BEE_POLLINATE, 1.0f, 1.0f);
            }
        }

        @Nullable
        private BlockPos getFlower() {
            List list2 = this.bee.getBlockInRange(pos -> EntityBee.isFlowerValid(this.bee.field_70170_p.func_180495_p(pos)), 5);
            if (list2.isEmpty()) {
                return null;
            }
            return (BlockPos)list2.get(this.bee.func_70681_au().nextInt(list2.size()));
        }
    }

    private static final class AIFindHive
    extends AINotAngry {
        private AIFindHive(EntityBee bee) {
            super(bee);
        }

        @Override
        public boolean canBeeStart() {
            return this.bee.field_70173_aa % 10 == 0 && !this.bee.hasHive();
        }

        @Override
        public boolean canBeeContinue() {
            return false;
        }

        public void func_75249_e() {
            List possibleHives = this.bee.getBlockInRange(pos -> this.bee.field_70170_p.func_175625_s(pos) instanceof BeeHiveTile && !((BeeHiveTile)this.bee.field_70170_p.func_175625_s(pos)).isFullOfBees(), 20);
            for (BlockPos hive : possibleHives) {
                TileEntity tile = this.bee.field_70170_p.func_175625_s(hive);
                if (!(tile instanceof BeeHiveTile) || ((BeeHiveTile)tile).isFullOfBees()) continue;
                this.bee.hivePos = hive;
            }
        }
    }

    public static final class AIGrowCrops
    extends AINotAngry {
        private AIGrowCrops(EntityBee entityBee) {
            super(entityBee);
        }

        @Override
        public boolean canBeeStart() {
            if (this.bee.getCropsGrownSincePollination() >= 10) {
                return false;
            }
            if (this.bee.field_70146_Z.nextFloat() < 0.3f) {
                return false;
            }
            return this.bee.hasNectar() && this.bee.isHiveValid();
        }

        @Override
        public boolean canBeeContinue() {
            return this.canBeeStart();
        }

        public void func_75246_d() {
            if (this.bee.field_70146_Z.nextInt(30) == 0) {
                for (int i2 = 1; i2 <= 2; ++i2) {
                    BlockPos pos = this.bee.func_180425_c().func_177979_c(i2);
                    IBlockState state = this.bee.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    BeePollinationHandler handler2 = BeePollinationHandlerJVM.getHandler(block);
                    if (handler2 == null || !handler2.pollinateCrop(this.bee.field_70170_p, pos, state, this.bee)) continue;
                    ++this.bee.cropsGrownSincePollination;
                }
            }
        }
    }

    private static final class AISting
    extends EntityAIAttackMelee {
        private AISting(EntityBee creature, double speedIn, boolean useLongMemory) {
            super((EntityCreature)creature, speedIn, useLongMemory);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && ((EntityBee)this.field_75441_b).isAngry() && !((EntityBee)this.field_75441_b).hasStung();
        }

        public boolean func_75253_b() {
            return super.func_75250_a() && ((EntityBee)this.field_75441_b).isAngry() && !((EntityBee)this.field_75441_b).hasStung();
        }
    }

    private static final class AIEnterHive
    extends AINotAngry {
        private AIEnterHive(EntityBee entityBee) {
            super(entityBee);
        }

        @Override
        public boolean canBeeStart() {
            TileEntity te;
            if (this.bee.hasNectar() && this.bee.hasHive() && !this.bee.hasStung() && this.bee.canEnterHive() && this.bee.hivePos.func_177951_i((Vec3i)this.bee.func_180425_c()) < 4.0 && (te = this.bee.field_70170_p.func_175625_s(this.bee.hivePos)) instanceof BeeHiveTile) {
                BeeHiveTile hive = (BeeHiveTile)te;
                if (!hive.isFullOfBees()) {
                    return true;
                }
                this.bee.hivePos = null;
            }
            return false;
        }

        @Override
        public boolean canBeeContinue() {
            return false;
        }

        public void func_75249_e() {
            TileEntity tile = this.bee.field_70170_p.func_175625_s(this.bee.hivePos);
            if (tile instanceof BeeHiveTile) {
                BeeHiveTile hive = (BeeHiveTile)tile;
                hive.tryEnterHive(this.bee, this.bee.hasNectar(), 0);
            }
        }
    }
}

