/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.world.gen.feature;

import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.futuremc.block.villagepillage.BlockBamboo;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.world.gen.feature.FWorldGen;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lthedarkcolour/futuremc/world/gen/feature/BambooWorldGen;", "Lthedarkcolour/futuremc/world/gen/feature/FWorldGen;", "()V", "VALID_BIOMES", "", "Lnet/minecraft/world/biome/Biome;", "kotlin.jvm.PlatformType", "generate", "", "rand", "Ljava/util/Random;", "chunkX", "", "chunkZ", "worldIn", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "random", "pos", "Lnet/minecraft/util/math/BlockPos;", "isBiomeValid", "", "biome", "future-mc"})
public final class BambooWorldGen
implements FWorldGen {
    private static final Set<Biome> VALID_BIOMES;
    @NotNull
    public static final BambooWorldGen INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final void generate(World worldIn, Random random, BlockPos pos) {
        BlockBamboo bamboo;
        block6: {
            block5: {
                bamboo = FBlocks.BAMBOO;
                IBlockState iBlockState = worldIn.func_180495_p(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
                if (!iBlockState.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) || !bamboo.func_176196_c(worldIn, pos)) break block5;
                Biome biome = worldIn.func_180494_b(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)biome, (String)"worldIn.getBiome(pos)");
                if (this.isBiomeValid(biome)) break block6;
            }
            return;
        }
        worldIn.func_175656_a(pos, bamboo.func_176223_P());
        int n = 0;
        int n2 = 9;
        while (n <= n2) {
            void j;
            IBlockState iBlockState = worldIn.func_180495_p(pos);
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"worldIn.getBlockState(pos)");
            if (Intrinsics.areEqual((Object)iBlockState.func_177230_c(), (Object)((Object)bamboo)) && bamboo.func_176473_a(worldIn, pos, worldIn.func_180495_p(pos), false)) {
                IBlockState iBlockState2 = worldIn.func_180495_p(pos);
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"worldIn.getBlockState(pos)");
                bamboo.func_176474_b(worldIn, random, pos, iBlockState2);
            }
            ++j;
        }
    }

    @Override
    public void generate(@NotNull Random rand, int chunkX, int chunkZ, @NotNull World worldIn, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
        int x = chunkX + rand.nextInt(16) + 8;
        int z = chunkZ + rand.nextInt(16) + 8;
        BlockPos position = new BlockPos(x, 0, z);
        if (!worldIn.func_175667_e(position)) {
            return;
        }
        Biome biome = worldIn.getBiomeForCoordsBody(position);
        Chunk chunk = worldIn.func_72964_e(chunkX, chunkZ);
        Intrinsics.checkExpressionValueIsNotNull((Object)chunk, (String)"worldIn.getChunk(chunkX, chunkZ)");
        ChunkPos chunkPos = chunk.func_76632_l();
        Biome biome2 = biome;
        Intrinsics.checkExpressionValueIsNotNull((Object)biome2, (String)"biome");
        if (this.isBiomeValid(biome2) && Intrinsics.areEqual((Object)worldIn.func_175624_G(), (Object)WorldType.field_77138_c) ^ true) {
            ChunkPos chunkPos2 = chunkPos;
            Intrinsics.checkExpressionValueIsNotNull((Object)chunkPos2, (String)"chunkPos");
            int n = 0;
            this.placeAround(worldIn, rand, chunkPos2, new IntRange(n, 12), (Function3<? super World, ? super Random, ? super BlockPos, Unit>)((Function3)new Function3<World, Random, BlockPos, Unit>(this){

                public final void invoke(@NotNull World p1, @NotNull Random p2, @NotNull BlockPos p3) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                    Intrinsics.checkParameterIsNotNull((Object)p3, (String)"p3");
                    BambooWorldGen.access$generate((BambooWorldGen)this.receiver, p1, p2, p3);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(BambooWorldGen.class);
                }

                public final String getName() {
                    return "generate";
                }

                public final String getSignature() {
                    return "generate(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)V";
                }
            }));
        }
    }

    private final boolean isBiomeValid(Biome biome) {
        return VALID_BIOMES.contains(biome);
    }

    private BambooWorldGen() {
    }

    static {
        BambooWorldGen bambooWorldGen;
        INSTANCE = bambooWorldGen = new BambooWorldGen();
        VALID_BIOMES = SetsKt.setOf((Object[])new Biome[]{Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_185446_X, Biomes.field_185447_Y});
    }

    @Override
    public void decorate(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        FWorldGen.DefaultImpls.decorate(this, worldIn, rand, pos);
    }

    public static final /* synthetic */ void access$generate(BambooWorldGen $this, World worldIn, Random random, BlockPos pos) {
        $this.generate(worldIn, random, pos);
    }
}

